/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

public class StringArray {
    private final String[] m_list;

    public StringArray(String[] list) {
        this.validateArray(list);
        this.m_list = list;
    }

    public StringArray(String[] list, StringArray base) {
        this.validateArray(list);
        this.m_list = this.mergeArrays(list, base.m_list);
    }

    public StringArray(StringArray array1, StringArray array2) {
        this.m_list = this.mergeArrays(array1.m_list, array2.m_list);
    }

    public StringArray(String[] list, StringArray array1, StringArray array2) {
        this.validateArray(list);
        this.m_list = this.mergeArrays(list, this.mergeArrays(array1.m_list, array2.m_list));
    }

    public StringArray(String[] list, StringArray array1, StringArray array2, StringArray array3) {
        this.validateArray(list);
        this.m_list = this.mergeArrays(list, this.mergeArrays(array1.m_list, this.mergeArrays(array2.m_list, array3.m_list)));
    }

    public StringArray(String[] list, StringArray array1, StringArray array2, StringArray array3, StringArray array4) {
        this.validateArray(list);
        this.m_list = this.mergeArrays(list, this.mergeArrays(array1.m_list, this.mergeArrays(array2.m_list, this.mergeArrays(array3.m_list, array4.m_list))));
    }

    private String[] mergeArrays(String[] list1, String[] list2) {
        String[] merge = new String[list1.length + list2.length];
        int fill = 0;
        int i = 0;
        int j = 0;
        while (i < list1.length && j < list2.length) {
            int diff = list2[j].compareTo(list1[i]);
            if (diff > 0) {
                merge[fill++] = list1[i++];
                continue;
            }
            if (diff < 0) {
                merge[fill++] = list2[j++];
                continue;
            }
            throw new IllegalArgumentException("Repeated value not allowed: \"" + list1[i] + '\"');
        }
        if (i < list1.length) {
            System.arraycopy(list1, i, merge, fill, list1.length - i);
        }
        if (j < list2.length) {
            System.arraycopy(list2, j, merge, fill, list2.length - j);
        }
        return merge;
    }

    private void validateArray(String[] list) {
        if (list.length > 0) {
            String last = list[0];
            int index = 0;
            while (++index < list.length) {
                String comp = list[index];
                int diff = last.compareTo(comp);
                if (diff > 0) {
                    throw new IllegalArgumentException("Array values are not ordered");
                }
                if (diff < 0) {
                    last = comp;
                    continue;
                }
                throw new IllegalArgumentException("Duplicate values in array");
            }
        }
    }

    public String get(int index) {
        return this.m_list[index];
    }

    public int indexOf(String value) {
        int base = 0;
        int limit = this.m_list.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff = value.compareTo(this.m_list[cur]);
            if (diff < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff > 0) {
                base = cur + 1;
                continue;
            }
            return cur;
        }
        return -1;
    }

    public int size() {
        return this.m_list.length;
    }
}

