/*
 * Decompiled with CFR 0.152.
 */
package com.prioritysoftware.CTEPIntegration;

import com.pegusapps.jctep.Service;
import com.pegusapps.jctep.ServiceFactory;
import com.pegusapps.jctep.ServiceListener;
import com.pegusapps.jctep.ServiceNotificationsListener;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.TerminalEvent;
import com.pegusapps.jctep.transaction.sale.LastTransactionStatusListener;
import com.pegusapps.jctep.transaction.sale.LastTransactionStatusResult;
import com.pegusapps.jctep.transaction.sale.LastTransactionStatusTransaction;
import com.pegusapps.jctep.transaction.sale.SaleListener;
import com.pegusapps.jctep.transaction.sale.SaleResult;
import com.pegusapps.jctep.transaction.sale.SaleTransaction;
import com.prioritysoftware.CTEPIntegration.DaveResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MainController
implements ServiceListener,
ServiceNotificationsListener {
    private Service service;
    private TransactionStatus status;
    private final DaveResult transactionResult = new DaveResult();

    @Override
    public void onServiceStart() {
    }

    @Override
    public void onServiceStop() {
    }

    @Override
    public void onTerminalConnect(Terminal terminal) {
    }

    @Override
    public void onTerminalDisconnect(Terminal terminal) {
    }

    @Override
    public void onTerminalEvent(TerminalEvent terminalEvent) {
    }

    public void doTransaction(double amount, String merchantsReference, String terminalID) {
        this.status = TransactionStatus.IN_PROGRESS;
        SaleTransaction saleTransaction = new SaleTransaction(amount).setMerchantReference(merchantsReference).set(new SaleListener(){

            @Override
            public void transactionResult(SaleResult saleResult) {
                if (MainController.this.status == TransactionStatus.IN_PROGRESS) {
                    MainController.this.transactionResult.setSaleResult(saleResult);
                    MainController.this.status = TransactionStatus.COMPLETED;
                }
            }
        });
        saleTransaction.send(this.service.getTerminal(terminalID));
    }

    public void createService(int portNumber) {
        this.service = ServiceFactory.createTcpIpService(portNumber, this, this);
        this.service.startService();
    }

    public void stopService() {
        this.service.stopService();
    }

    public List<String> getTerminalIds() {
        ArrayList<String> connectedTerminals = new ArrayList<String>();
        Iterator<Terminal> itr = this.service.getConnectedTerminals();
        while (itr.hasNext()) {
            Terminal t = itr.next();
            connectedTerminals.add(t.getTerminalId());
        }
        return connectedTerminals;
    }

    public boolean hasFinished() {
        return this.status == TransactionStatus.COMPLETED;
    }

    public void resetStatus() {
        this.status = TransactionStatus.IDLE;
        this.transactionResult.setSaleResult(null);
        this.transactionResult.setLastTransactionStatusResult(null);
    }

    public DaveResult getDaveResult() {
        return this.transactionResult;
    }

    public void requestLatestTransationResult(String terminalId) {
        this.status = TransactionStatus.CALLED_FOR_LATEST;
        LastTransactionStatusTransaction lastTransactionStatusTransaction = new LastTransactionStatusTransaction(new LastTransactionStatusListener(){

            @Override
            public void transactionResult(LastTransactionStatusResult lastTransactionStatusResult) {
                MainController.this.transactionResult.setLastTransactionStatusResult(lastTransactionStatusResult);
            }
        });
        lastTransactionStatusTransaction.send(this.service.getTerminal(terminalId));
    }

    public void cleanup() {
        ServiceFactory.cleanup();
    }

    private static enum TransactionStatus {
        IDLE,
        IN_PROGRESS,
        COMPLETED,
        CALLED_FOR_LATEST;

    }
}

