/*
 * Decompiled with CFR 0.152.
 */
package com.prioritysoftware.CTEPIntegration;

import com.prioritysoftware.CTEPIntegration.DaveResult;
import com.prioritysoftware.CTEPIntegration.MainController;
import java.lang.reflect.Field;
import java.util.List;
import sun.awt.OSInfo;

public final class CTEP {
    private MainController ctrl;
    private String terminalID = null;

    public CTEP(int portNumber) throws NoSuchFieldException, IllegalAccessException {
        this.ctrl = new MainController();
        this.ctrl.createService(portNumber);
    }

    public CTEP(int portNumber, char[] libraryPath) throws NoSuchFieldException, IllegalAccessException {
        if (OSInfo.getOSType() == OSInfo.OSType.MACOSX) {
            System.setProperty("java.library.path", String.valueOf(libraryPath));
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        this.ctrl = new MainController();
        this.ctrl.createService(portNumber);
    }

    public void stopService() {
        this.ctrl.stopService();
    }

    public String[] getAvailableTerminals() {
        List<String> result = this.ctrl.getTerminalIds();
        String[] resultArray = new String[result.size()];
        return result.isEmpty() ? null : result.toArray(resultArray);
    }

    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID.equals("") ? null : terminalID;
    }

    public void doTransaction(double amount, String merchReference) {
        this.ctrl.doTransaction(amount, merchReference, this.terminalID);
    }

    public boolean isConnected(String terminalID) {
        return this.ctrl.getTerminalIds().contains(terminalID);
    }

    public DaveResult getTransactionResult() {
        if (this.ctrl.getDaveResult().holdsTransaction()) {
            return this.ctrl.getDaveResult();
        }
        return null;
    }

    public void requestLatestTransactionResult() {
        this.ctrl.requestLatestTransationResult(this.terminalID);
    }

    public boolean hasFinished() {
        try {
            Thread.sleep(1000L);
            return this.ctrl.hasFinished();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void reset() {
        this.ctrl.resetStatus();
    }

    public void restartService(int portNumber) {
        if (this.ctrl != null) {
            this.ctrl.stopService();
            this.ctrl = null;
        }
        this.ctrl = new MainController();
        this.ctrl.createService(portNumber);
    }

    public void cleanup() {
        if (this.ctrl != null) {
            this.ctrl.cleanup();
        }
    }
}

