/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.ticket;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.ticket.PrintTicketListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class PrintTicketTransactionHelper {
    PrintTicketTransactionHelper() {
    }

    public static native PrintTicketTransactionHelper create();

    public abstract void printTicket(Terminal var1, String var2, PrintTicketListener var3);

    private static final class CppProxy
    extends PrintTicketTransactionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void printTicket(Terminal terminal, String ticketText, PrintTicketListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_printTicket(this.nativeRef, terminal, ticketText, listener);
        }

        private native void native_printTicket(long var1, Terminal var3, String var4, PrintTicketListener var5);
    }
}

