/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.serviceinformation;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.serviceinformation.ServiceInformationActionRequest;
import com.pegusapps.jctep.transaction.serviceinformation.ServiceInformationListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ServiceInformationHelper {
    ServiceInformationHelper() {
    }

    public static native ServiceInformationHelper create();

    public abstract void requestInformation(Terminal var1, ServiceInformationActionRequest var2, ServiceInformationListener var3);

    private static final class CppProxy
    extends ServiceInformationHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void requestInformation(Terminal terminal, ServiceInformationActionRequest actionRequest, ServiceInformationListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_requestInformation(this.nativeRef, terminal, actionRequest, listener);
        }

        private native void native_requestInformation(long var1, Terminal var3, ServiceInformationActionRequest var4, ServiceInformationListener var5);
    }
}

