/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.sale;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.sale.AbstractSaleListener;
import com.pegusapps.jctep.transaction.sale.AbstractSaleTransaction;
import com.pegusapps.jctep.transaction.sale.CardBrandIdentifier;
import com.pegusapps.jctep.transaction.sale.SaleAction;
import com.pegusapps.jctep.transaction.sale.SaleListener;
import com.pegusapps.jctep.transaction.sale.SaleResult;
import com.pegusapps.jctep.transaction.sale.SaleWithCashbackListener;

public class SaleWithCashbackTransaction
extends AbstractSaleTransaction {
    protected double cashbackAmount;

    public SaleWithCashbackTransaction(double amount, double cashbackAmount) {
        super(amount, new SaleListener(){

            @Override
            public void transactionResult(SaleResult result) {
            }
        });
        this.cashbackAmount = cashbackAmount;
    }

    public SaleWithCashbackTransaction(double amount, double cashbackAmount, SaleWithCashbackListener listener) {
        super(amount, listener);
        this.cashbackAmount = cashbackAmount;
    }

    @Deprecated
    public SaleWithCashbackTransaction(double amount, double cashbackAmount, String merchantReference, SaleWithCashbackListener listener) {
        super(amount, merchantReference, listener);
        this.cashbackAmount = cashbackAmount;
    }

    @Deprecated
    public SaleWithCashbackTransaction(double amount, double cashbackAmount, String merchantReference, SaleSystemActionIdentifier saleSystemActionIdentifier, SaleWithCashbackListener listener) {
        super(amount, merchantReference, saleSystemActionIdentifier, (AbstractSaleListener)listener);
        this.cashbackAmount = cashbackAmount;
    }

    @Deprecated
    public SaleWithCashbackTransaction(double amount, double cashbackAmount, String merchantReference, byte[] discretionaryData, SaleWithCashbackListener listener) {
        super(amount, merchantReference, discretionaryData, (AbstractSaleListener)listener);
        this.cashbackAmount = cashbackAmount;
    }

    @Deprecated
    public SaleWithCashbackTransaction(double amount, double cashbackAmount, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, SaleWithCashbackListener listener) {
        super(amount, merchantReference, discretionaryData, saleSystemActionIdentifier, listener);
        this.cashbackAmount = cashbackAmount;
    }

    public SaleWithCashbackTransaction set(SaleWithCashbackListener listener) {
        this.listener = listener;
        return this;
    }

    public SaleWithCashbackTransaction setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    public SaleWithCashbackTransaction set(SaleSystemActionIdentifier saleSystemActionIdentifier) {
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        return this;
    }

    public SaleWithCashbackTransaction setDiscretionaryData(byte[] discretionaryData) {
        this.discretionaryData = discretionaryData;
        return this;
    }

    public SaleWithCashbackTransaction add(CardBrandIdentifier filter) {
        this.cardBrandIdentifierFilter.add(filter);
        return this;
    }

    public SaleWithCashbackTransaction addProprietaryData(byte[] data) {
        this.proprietaryData = data;
        return this;
    }

    @Override
    public SaleWithCashbackTransaction setAcquirerDiscretionaryData(String data) {
        this.acquirerDiscretionaryData = data;
        return this;
    }

    public SaleWithCashbackTransaction setRequestAcquirerToken(boolean requestAcquirerToken) {
        this.requestAcquirerToken = requestAcquirerToken;
        return this;
    }

    public SaleWithCashbackTransaction setRequestCardToken(boolean requestCardToken) {
        this.requestCardToken = requestCardToken;
        return this;
    }

    @Override
    public void send(Terminal terminal) {
        this.saleTransactionHelper.makeSaleWithCashback(terminal, this.amount, this.cashbackAmount, this.merchantReference, this.discretionaryData, this.saleSystemActionIdentifier, this.saleTransactionHelper.cardBrandIdentifiersToLongArray(this.cardBrandIdentifierFilter), this.proprietaryData, this.acquirerDiscretionaryData, this.requestAcquirerToken, this.requestCardToken, (SaleWithCashbackListener)this.listener);
    }

    @Override
    protected SaleAction getAction() {
        return null;
    }
}

