/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.sale;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.sale.AuthorizedSaleAction;
import com.pegusapps.jctep.transaction.sale.AuthorizedSaleListener;
import com.pegusapps.jctep.transaction.sale.CancelRetailListener;
import com.pegusapps.jctep.transaction.sale.CardBrandIdentifier;
import com.pegusapps.jctep.transaction.sale.LastTransactionStatusListener;
import com.pegusapps.jctep.transaction.sale.SaleAction;
import com.pegusapps.jctep.transaction.sale.SaleListener;
import com.pegusapps.jctep.transaction.sale.SaleWithCashbackListener;
import com.pegusapps.jctep.transaction.sale.SaleWithDeliveryConfirmationListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class SaleTransactionHelper {
    SaleTransactionHelper() {
    }

    public abstract void makeSale(Terminal var1, SaleAction var2, double var3, String var5, byte[] var6, SaleSystemActionIdentifier var7, long[] var8, byte[] var9, String var10, boolean var11, boolean var12, SaleListener var13);

    public abstract void makeSaleWithCashback(Terminal var1, double var2, double var4, String var6, byte[] var7, SaleSystemActionIdentifier var8, long[] var9, byte[] var10, String var11, boolean var12, boolean var13, SaleWithCashbackListener var14);

    public abstract void makeSaleWithDeliveryConfirmation(Terminal var1, double var2, String var4, byte[] var5, SaleSystemActionIdentifier var6, long[] var7, byte[] var8, String var9, boolean var10, boolean var11, SaleWithDeliveryConfirmationListener var12);

    public abstract void makeAuthorizedSale(Terminal var1, AuthorizedSaleAction var2, double var3, String var5, byte[] var6, String var7, SaleSystemActionIdentifier var8, long[] var9, byte[] var10, String var11, String var12, boolean var13, boolean var14, AuthorizedSaleListener var15);

    public abstract void makeSmartPaySale(Terminal var1, double var2, String var4, SaleSystemActionIdentifier var5, SaleListener var6);

    public abstract void cancelRetail(Terminal var1, CancelRetailListener var2);

    public abstract void getLastTransaction(Terminal var1, LastTransactionStatusListener var2);

    public static native SaleTransactionHelper create();

    public long[] cardBrandIdentifiersToLongArray(List<CardBrandIdentifier> cardBrandIdentifierFilters) {
        return cardBrandIdentifierFilters.stream().mapToLong(CardBrandIdentifier::getValue).toArray();
    }

    private static final class CppProxy
    extends SaleTransactionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void makeSale(Terminal terminal, SaleAction action, double amount, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, long[] cardBrandIdentifierFilter, byte[] proprietaryData, String acquirerDiscretionaryData, boolean requestAcquirerToken, boolean requestCardToken, SaleListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_makeSale(this.nativeRef, terminal, action, amount, merchantReference, discretionaryData, saleSystemActionIdentifier, cardBrandIdentifierFilter, proprietaryData, acquirerDiscretionaryData, requestAcquirerToken, requestCardToken, listener);
        }

        private native void native_makeSale(long var1, Terminal var3, SaleAction var4, double var5, String var7, byte[] var8, SaleSystemActionIdentifier var9, long[] var10, byte[] var11, String var12, boolean var13, boolean var14, SaleListener var15);

        @Override
        public void makeAuthorizedSale(Terminal terminal, AuthorizedSaleAction action, double amount, String merchantReference, byte[] discretionaryData, String authorizationCode, SaleSystemActionIdentifier saleSystemActionIdentifier, long[] cardBrandIdentifierFilter, byte[] proprietaryData, String acquirerDiscretionaryData, String acquirerToken, boolean requestAcquirerToken, boolean requestCardToken, AuthorizedSaleListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_makeAuthorizedSale(this.nativeRef, terminal, action, amount, merchantReference, discretionaryData, authorizationCode, saleSystemActionIdentifier, cardBrandIdentifierFilter, proprietaryData, acquirerDiscretionaryData, acquirerToken, requestAcquirerToken, requestCardToken, listener);
        }

        private native void native_makeAuthorizedSale(long var1, Terminal var3, AuthorizedSaleAction var4, double var5, String var7, byte[] var8, String var9, SaleSystemActionIdentifier var10, long[] var11, byte[] var12, String var13, String var14, boolean var15, boolean var16, AuthorizedSaleListener var17);

        @Override
        public void makeSaleWithCashback(Terminal terminal, double amount, double cashbackAmount, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, long[] cardBrandIdentifierFilter, byte[] proprietaryData, String acquirerDiscretionaryData, boolean requestAcquirerToken, boolean requestCardToken, SaleWithCashbackListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_makeSaleWithCashback(this.nativeRef, terminal, amount, cashbackAmount, merchantReference, discretionaryData, saleSystemActionIdentifier, cardBrandIdentifierFilter, proprietaryData, acquirerDiscretionaryData, requestAcquirerToken, requestCardToken, listener);
        }

        private native void native_makeSaleWithCashback(long var1, Terminal var3, double var4, double var6, String var8, byte[] var9, SaleSystemActionIdentifier var10, long[] var11, byte[] var12, String var13, boolean var14, boolean var15, SaleWithCashbackListener var16);

        @Override
        public void makeSaleWithDeliveryConfirmation(Terminal terminal, double amount, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, long[] cardBrandIdentifierFilter, byte[] proprietaryData, String acquirerDiscretionaryData, boolean requestAcquirerToken, boolean requestCardToken, SaleWithDeliveryConfirmationListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_makeSaleWithDeliveryConfirmation(this.nativeRef, terminal, amount, merchantReference, discretionaryData, saleSystemActionIdentifier, cardBrandIdentifierFilter, proprietaryData, acquirerDiscretionaryData, requestAcquirerToken, requestCardToken, listener);
        }

        private native void native_makeSaleWithDeliveryConfirmation(long var1, Terminal var3, double var4, String var6, byte[] var7, SaleSystemActionIdentifier var8, long[] var9, byte[] var10, String var11, boolean var12, boolean var13, SaleWithDeliveryConfirmationListener var14);

        @Override
        public void makeSmartPaySale(Terminal terminal, double amount, String merchantReference, SaleSystemActionIdentifier saleSystemActionIdentifier, SaleListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_makeSmartPaySale(this.nativeRef, terminal, amount, merchantReference, saleSystemActionIdentifier, listener);
        }

        private native void native_makeSmartPaySale(long var1, Terminal var3, double var4, String var6, SaleSystemActionIdentifier var7, SaleListener var8);

        @Override
        public void cancelRetail(Terminal terminal, CancelRetailListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_cancelRetail(this.nativeRef, terminal, listener);
        }

        private native void native_cancelRetail(long var1, Terminal var3, CancelRetailListener var4);

        @Override
        public void getLastTransaction(Terminal terminal, LastTransactionStatusListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_getLastTransaction(this.nativeRef, terminal, listener);
        }

        private native void native_getLastTransaction(long var1, Terminal var3, LastTransactionStatusListener var4);
    }
}

