/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.sale;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.error.Error;
import com.pegusapps.jctep.transaction.TimestampHelper;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AuthorizedSaleResult {
    AuthorizedSaleResult() {
    }

    public Error getError() {
        return this.error();
    }

    public String getAuthorizationCode() {
        return this.authorizationCode();
    }

    public double getAuthorizedAmount() {
        return this.authorizedAmount();
    }

    public String getAcquirerDiscretionaryData() {
        return this.acquirerDiscretionaryData();
    }

    public String getAcquirerId() {
        return this.acquirerId();
    }

    public String getLanguage() {
        return this.language();
    }

    public String getClippedPAN() {
        return this.clippedPAN();
    }

    public String getCardBrandName() {
        return this.cardBrandName();
    }

    public String getCardBrandIdentifier() {
        return this.cardBrandIdentifier();
    }

    public String getClientTicket() {
        return this.clientTicket();
    }

    public String getMerchantTicket() {
        return this.merchantTicket();
    }

    public String getMerchantText() {
        return this.merchantText();
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired();
    }

    public Double getAdditionalAmount() {
        return this.additionalAmount();
    }

    public boolean isPartialApproval() {
        return this.partialApproval();
    }

    public Date getTimestamp() {
        return TimestampHelper.parseTimestamp(this.timestamp());
    }

    public SaleSystemActionIdentifier getSaleSystemActionIdentifier() {
        return this.saleSystemActionIdentifier();
    }

    public abstract boolean isContactless();

    public abstract boolean isMagneticStripe();

    public abstract boolean isIccEmv();

    public abstract boolean isIccNonEmv();

    public abstract boolean isBarCode();

    public abstract boolean isManualEntry();

    public abstract boolean isSynchronousChip();

    public abstract boolean isAsynchronousChip();

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    public boolean isBackupMode() {
        return this.processedInBackupMode();
    }

    public byte[] getProprietaryData() {
        return this.proprietaryData();
    }

    abstract Error error();

    abstract String authorizationCode();

    abstract double authorizedAmount();

    abstract String acquirerDiscretionaryData();

    abstract String acquirerId();

    abstract String language();

    abstract String clippedPAN();

    abstract String cardBrandName();

    abstract String cardBrandIdentifier();

    abstract String clientTicket();

    abstract String merchantTicket();

    abstract String merchantText();

    abstract boolean signatureRequired();

    abstract Double additionalAmount();

    abstract boolean partialApproval();

    abstract String timestamp();

    abstract SaleSystemActionIdentifier saleSystemActionIdentifier();

    abstract boolean processedInBackupMode();

    abstract byte[] proprietaryData();

    private static final class CppProxy
    extends AuthorizedSaleResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public String authorizationCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_authorizationCode(this.nativeRef);
        }

        private native String native_authorizationCode(long var1);

        @Override
        public double authorizedAmount() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_authorizedAmount(this.nativeRef);
        }

        private native double native_authorizedAmount(long var1);

        @Override
        public String acquirerDiscretionaryData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_acquirerDiscretionaryData(this.nativeRef);
        }

        private native String native_acquirerDiscretionaryData(long var1);

        @Override
        public String acquirerId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_acquirerId(this.nativeRef);
        }

        private native String native_acquirerId(long var1);

        @Override
        public String language() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_language(this.nativeRef);
        }

        private native String native_language(long var1);

        @Override
        public String clippedPAN() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_clippedPAN(this.nativeRef);
        }

        private native String native_clippedPAN(long var1);

        @Override
        public String cardBrandName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardBrandName(this.nativeRef);
        }

        private native String native_cardBrandName(long var1);

        @Override
        public String cardBrandIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardBrandIdentifier(this.nativeRef);
        }

        private native String native_cardBrandIdentifier(long var1);

        @Override
        public String clientTicket() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_clientTicket(this.nativeRef);
        }

        private native String native_clientTicket(long var1);

        @Override
        public String merchantTicket() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_merchantTicket(this.nativeRef);
        }

        private native String native_merchantTicket(long var1);

        @Override
        public String merchantText() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_merchantText(this.nativeRef);
        }

        private native String native_merchantText(long var1);

        @Override
        public boolean signatureRequired() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_signatureRequired(this.nativeRef);
        }

        private native boolean native_signatureRequired(long var1);

        @Override
        public Double additionalAmount() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_additionalAmount(this.nativeRef);
        }

        private native Double native_additionalAmount(long var1);

        @Override
        public boolean partialApproval() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_partialApproval(this.nativeRef);
        }

        private native boolean native_partialApproval(long var1);

        @Override
        public SaleSystemActionIdentifier saleSystemActionIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_saleSystemActionIdentifier(this.nativeRef);
        }

        private native SaleSystemActionIdentifier native_saleSystemActionIdentifier(long var1);

        @Override
        public String timestamp() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_timestamp(this.nativeRef);
        }

        private native String native_timestamp(long var1);

        @Override
        public boolean isContactless() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isContactless(this.nativeRef);
        }

        private native boolean native_isContactless(long var1);

        @Override
        public boolean isMagneticStripe() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isMagneticStripe(this.nativeRef);
        }

        private native boolean native_isMagneticStripe(long var1);

        @Override
        public boolean isIccEmv() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isIccEmv(this.nativeRef);
        }

        private native boolean native_isIccEmv(long var1);

        @Override
        public boolean isIccNonEmv() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isIccNonEmv(this.nativeRef);
        }

        private native boolean native_isIccNonEmv(long var1);

        @Override
        public boolean isBarCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isBarCode(this.nativeRef);
        }

        private native boolean native_isBarCode(long var1);

        @Override
        public boolean isManualEntry() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isManualEntry(this.nativeRef);
        }

        private native boolean native_isManualEntry(long var1);

        @Override
        public boolean isSynchronousChip() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isSynchronousChip(this.nativeRef);
        }

        private native boolean native_isSynchronousChip(long var1);

        @Override
        public boolean isAsynchronousChip() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isAsynchronousChip(this.nativeRef);
        }

        private native boolean native_isAsynchronousChip(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);

        @Override
        public boolean processedInBackupMode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_processedInBackupMode(this.nativeRef);
        }

        private native boolean native_processedInBackupMode(long var1);

        @Override
        public byte[] proprietaryData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_proprietaryData(this.nativeRef);
        }

        private native byte[] native_proprietaryData(long var1);
    }
}

