/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.sale;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.sale.AbstractSaleListener;
import com.pegusapps.jctep.transaction.sale.CardBrandIdentifier;
import com.pegusapps.jctep.transaction.sale.SaleAction;
import com.pegusapps.jctep.transaction.sale.SaleListener;
import com.pegusapps.jctep.transaction.sale.SaleTransactionHelper;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractSaleTransaction {
    protected SaleAction action;
    protected double amount;
    protected String merchantReference;
    protected byte[] discretionaryData;
    protected byte[] proprietaryData;
    protected SaleSystemActionIdentifier saleSystemActionIdentifier;
    protected AbstractSaleListener listener;
    protected String acquirerDiscretionaryData;
    protected boolean requestAcquirerToken;
    protected boolean requestCardToken;
    protected SaleTransactionHelper saleTransactionHelper;
    protected List<CardBrandIdentifier> cardBrandIdentifierFilter = new ArrayList<CardBrandIdentifier>();

    protected abstract SaleAction getAction();

    protected AbstractSaleTransaction() {
        this.action = this.getAction();
        this.saleTransactionHelper = SaleTransactionHelper.create();
    }

    public AbstractSaleTransaction(double amount, AbstractSaleListener listener) {
        this();
        this.amount = amount;
        this.listener = listener;
    }

    public AbstractSaleTransaction(double amount, String merchantReference, AbstractSaleListener listener) {
        this();
        this.amount = amount;
        this.merchantReference = merchantReference;
        this.listener = listener;
    }

    public AbstractSaleTransaction(double amount, String merchantReference, SaleSystemActionIdentifier saleSystemActionIdentifier, AbstractSaleListener listener) {
        this();
        this.amount = amount;
        this.merchantReference = merchantReference;
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        this.listener = listener;
    }

    public AbstractSaleTransaction(double amount, String merchantReference, byte[] discretionaryData, AbstractSaleListener listener) {
        this();
        this.amount = amount;
        this.merchantReference = merchantReference;
        this.discretionaryData = discretionaryData;
        this.listener = listener;
    }

    public AbstractSaleTransaction(double amount, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, AbstractSaleListener listener) {
        this();
        this.amount = amount;
        this.merchantReference = merchantReference;
        this.discretionaryData = discretionaryData;
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        this.listener = listener;
    }

    public void send(Terminal terminal) {
        this.saleTransactionHelper.makeSale(terminal, this.action, this.amount, this.merchantReference, this.discretionaryData, this.saleSystemActionIdentifier, this.saleTransactionHelper.cardBrandIdentifiersToLongArray(this.cardBrandIdentifierFilter), this.proprietaryData, this.acquirerDiscretionaryData, this.requestAcquirerToken, this.requestCardToken, (SaleListener)this.listener);
    }

    public AbstractSaleTransaction setAcquirerDiscretionaryData(String data) {
        this.acquirerDiscretionaryData = data;
        return this;
    }
}

