/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.sale;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.sale.AuthorizedSaleAction;
import com.pegusapps.jctep.transaction.sale.AuthorizedSaleListener;
import com.pegusapps.jctep.transaction.sale.CardBrandIdentifier;
import com.pegusapps.jctep.transaction.sale.SaleTransactionHelper;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractAuthorizedSaleTransaction {
    protected AuthorizedSaleAction action;
    protected double amount;
    protected String merchantReference;
    protected byte[] discretionaryData;
    protected byte[] proprietaryData;
    protected String authorizationCode;
    protected SaleSystemActionIdentifier saleSystemActionIdentifier;
    protected AuthorizedSaleListener listener;
    protected String acquirerDiscretionaryData;
    protected String acquirerToken;
    protected boolean requestAcquirerToken;
    protected boolean requestCardToken;
    protected SaleTransactionHelper saleTransactionHelper;
    protected List<CardBrandIdentifier> cardBrandIdentifierFilter = new ArrayList<CardBrandIdentifier>();

    protected abstract AuthorizedSaleAction getAction();

    protected AbstractAuthorizedSaleTransaction() {
        this.action = this.getAction();
        this.saleTransactionHelper = SaleTransactionHelper.create();
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.listener = listener;
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, SaleSystemActionIdentifier saleSystemActionIdentifier, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        this.listener = listener;
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, String merchantReference, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.merchantReference = merchantReference;
        this.listener = listener;
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, String merchantReference, SaleSystemActionIdentifier saleSystemActionIdentifier, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.merchantReference = merchantReference;
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        this.listener = listener;
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, String merchantReference, byte[] discretionaryData, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.merchantReference = merchantReference;
        this.discretionaryData = discretionaryData;
        this.listener = listener;
    }

    public AbstractAuthorizedSaleTransaction(double amount, String authorizationCode, String merchantReference, byte[] discretionaryData, SaleSystemActionIdentifier saleSystemActionIdentifier, AuthorizedSaleListener listener) {
        this();
        this.amount = amount;
        this.authorizationCode = authorizationCode;
        this.merchantReference = merchantReference;
        this.discretionaryData = discretionaryData;
        this.saleSystemActionIdentifier = saleSystemActionIdentifier;
        this.listener = listener;
    }

    public void send(Terminal terminal) {
        this.saleTransactionHelper.makeAuthorizedSale(terminal, this.action, this.amount, this.merchantReference, this.discretionaryData, this.authorizationCode, this.saleSystemActionIdentifier, this.saleTransactionHelper.cardBrandIdentifiersToLongArray(this.cardBrandIdentifierFilter), this.proprietaryData, this.acquirerDiscretionaryData, this.acquirerToken, this.requestAcquirerToken, this.requestCardToken, this.listener);
    }

    public AbstractAuthorizedSaleTransaction setAcquirerDiscretionaryData(String data) {
        this.acquirerDiscretionaryData = data;
        return this;
    }

    public AbstractAuthorizedSaleTransaction setAcquirerToken(String acquirerToken) {
        this.acquirerToken = acquirerToken;
        return this;
    }

    public AbstractAuthorizedSaleTransaction setRequestAcquirerToken(boolean requestAcquirerToken) {
        this.requestAcquirerToken = requestAcquirerToken;
        return this;
    }

    public AbstractAuthorizedSaleTransaction setRequestCardToken(boolean requestCardToken) {
        this.requestCardToken = requestCardToken;
        return this;
    }
}

