/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.mmi;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.encryption.EncryptionAlgorithm;
import com.pegusapps.jctep.transaction.mmi.EncryptedData;
import com.pegusapps.jctep.transaction.mmi.FreeText;
import com.pegusapps.jctep.transaction.mmi.VerifyPinListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class VerifyPinHelper {
    VerifyPinHelper() {
    }

    public static native VerifyPinHelper create();

    public void verifyPin(Terminal terminal, EncryptedData encryptedPin, int screenIdentifier, String language, int displayTimeout, VerifyPinListener listener) {
        this.verifyPin(terminal, encryptedPin, screenIdentifier, language, displayTimeout, null, listener);
    }

    public abstract void verifyPin(Terminal var1, EncryptedData var2, int var3, String var4, int var5, FreeText var6, VerifyPinListener var7);

    public abstract void verifyPinFlow(Terminal var1, EncryptedData var2, String var3, int var4, int var5, boolean var6, FreeText var7, boolean var8, int var9, int var10, FreeText var11, boolean var12, int var13, int var14, FreeText var15, VerifyPinListener var16);

    private static final class CppProxy
    extends VerifyPinHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void verifyPin(Terminal terminal, EncryptedData encryptedPin, int screenIdentifier, String language, int displayTimeout, FreeText freeText, VerifyPinListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_verifyPin(this.nativeRef, terminal, encryptedPin.getEncryptedPin(), encryptedPin.getKeyIndex(), encryptedPin.getKeySerialNumber(), encryptedPin.getEncryptionData(), encryptedPin.getAlgorithm(), screenIdentifier, language, displayTimeout, freeText == null ? null : freeText.text_1, freeText == null ? null : freeText.text_2, freeText == null ? null : freeText.text_3, freeText == null ? null : freeText.text_4, listener);
        }

        private native void native_verifyPin(long var1, Terminal var3, String var4, int var5, String var6, String var7, EncryptionAlgorithm var8, int var9, String var10, int var11, String var12, String var13, String var14, String var15, VerifyPinListener var16);

        @Override
        public void verifyPinFlow(Terminal terminal, EncryptedData encryptedPin, String language, int displayTimeout, int maximumTries, boolean keepSession, FreeText freeText, boolean successNextMessage, int successNextMessageDisplayTimeout, int successNextMessageIdentifier, FreeText successNextMessageFreeText, boolean failNextMessage, int failNextMessageDisplayTimeout, int failNextMessageIdentifier, FreeText failNextMessageFreeText, VerifyPinListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_verifyPinFlow(this.nativeRef, terminal, encryptedPin.getEncryptedPin(), encryptedPin.getKeyIndex(), encryptedPin.getKeySerialNumber(), encryptedPin.getEncryptionData(), encryptedPin.getAlgorithm(), language, displayTimeout, maximumTries, keepSession, freeText == null ? null : freeText.text_1, freeText == null ? null : freeText.text_2, freeText == null ? null : freeText.text_3, freeText == null ? null : freeText.text_4, successNextMessage, successNextMessageDisplayTimeout, successNextMessageIdentifier, successNextMessageFreeText == null ? null : successNextMessageFreeText.text_1, successNextMessageFreeText == null ? null : successNextMessageFreeText.text_2, successNextMessageFreeText == null ? null : successNextMessageFreeText.text_3, successNextMessageFreeText == null ? null : successNextMessageFreeText.text_4, failNextMessage, failNextMessageDisplayTimeout, failNextMessageIdentifier, failNextMessageFreeText == null ? null : failNextMessageFreeText.text_1, failNextMessageFreeText == null ? null : failNextMessageFreeText.text_2, failNextMessageFreeText == null ? null : failNextMessageFreeText.text_3, failNextMessageFreeText == null ? null : failNextMessageFreeText.text_4, listener);
        }

        private native void native_verifyPinFlow(long var1, Terminal var3, String var4, int var5, String var6, String var7, EncryptionAlgorithm var8, String var9, int var10, int var11, boolean var12, String var13, String var14, String var15, String var16, boolean var17, int var18, int var19, String var20, String var21, String var22, String var23, boolean var24, int var25, int var26, String var27, String var28, String var29, String var30, VerifyPinListener var31);
    }
}

