/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.mmi;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.mmi.EncryptedData;
import com.pegusapps.jctep.transaction.mmi.FreeText;
import com.pegusapps.jctep.transaction.mmi.VerifyPinHelper;
import com.pegusapps.jctep.transaction.mmi.VerifyPinListener;

public class VerifyPinFlow {
    protected VerifyPinHelper transactionHelper = VerifyPinHelper.create();
    protected VerifyPinListener listener;
    protected EncryptedData encryptedPin;
    protected String language;
    protected int displayTimeout;
    protected int maximumTries;
    protected FreeText freeText;
    protected boolean keepSession;
    protected boolean successNextMessage;
    protected int successNextMessageDisplayTimeout;
    protected int successNextMessageIdentifier;
    protected FreeText successNextMessageFreeText;
    protected boolean failNextMessage;
    protected int failNextMessageIdentifier;
    protected int failNextMessageDisplayTimeout;
    protected FreeText failNextMessageFreeText;

    protected VerifyPinFlow() {
    }

    public VerifyPinFlow(EncryptedData encryptedPin, String language, int displayTimeout, int maximumTries, boolean keepSession, VerifyPinListener listener) {
        this(encryptedPin, language, displayTimeout, maximumTries, keepSession, null, listener);
    }

    public VerifyPinFlow(EncryptedData encryptedPin, String language, int displayTimeout, int maximumTries, boolean keepSession, FreeText freeText, VerifyPinListener listener) {
        this();
        this.listener = listener;
        this.encryptedPin = encryptedPin;
        this.maximumTries = maximumTries;
        this.language = language;
        this.displayTimeout = displayTimeout;
        this.freeText = freeText;
        this.keepSession = keepSession;
        this.successNextMessage = false;
        this.failNextMessage = false;
    }

    public VerifyPinFlow setFreeText(FreeText freeText) {
        this.freeText = freeText;
        return this;
    }

    public VerifyPinFlow setSuccessNextMessageData(int displayTimeout, int messageIdentifier, FreeText freeText) {
        this.successNextMessage = true;
        this.successNextMessageDisplayTimeout = displayTimeout;
        this.successNextMessageIdentifier = messageIdentifier;
        this.successNextMessageFreeText = freeText;
        return this;
    }

    public VerifyPinFlow setFailNextMessageData(int displayTimeout, int messageIdentifier, FreeText freeText) {
        this.failNextMessage = true;
        this.failNextMessageDisplayTimeout = displayTimeout;
        this.failNextMessageIdentifier = messageIdentifier;
        this.failNextMessageFreeText = freeText;
        return this;
    }

    public void send(Terminal terminal) {
        this.transactionHelper.verifyPinFlow(terminal, this.encryptedPin, this.language, this.displayTimeout, this.maximumTries, this.keepSession, this.freeText, this.successNextMessage, this.successNextMessageDisplayTimeout, this.successNextMessageIdentifier, this.successNextMessageFreeText, this.failNextMessage, this.failNextMessageDisplayTimeout, this.failNextMessageIdentifier, this.failNextMessageFreeText, this.listener);
    }
}

