/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.mmi;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.mmi.FreeText;
import com.pegusapps.jctep.transaction.mmi.ShowMessageListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ShowMessageHelper {
    ShowMessageHelper() {
    }

    public static native ShowMessageHelper create();

    public abstract void showMessage(Terminal var1, int var2, String var3, int var4, FreeText var5, ShowMessageListener var6);

    private static final class CppProxy
    extends ShowMessageHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void showMessage(Terminal terminal, int screenIdentifier, String language, int displayTimeout, FreeText freeText, ShowMessageListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_showMessage(this.nativeRef, terminal, screenIdentifier, language, displayTimeout, freeText == null ? null : freeText.text_1, freeText == null ? null : freeText.text_2, freeText == null ? null : freeText.text_3, freeText == null ? null : freeText.text_4, listener);
        }

        private native void native_showMessage(long var1, Terminal var3, int var4, String var5, int var6, String var7, String var8, String var9, String var10, ShowMessageListener var11);
    }
}

