/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.mmi;

import com.pegusapps.jctep.encryption.EncryptionAlgorithm;

public class EncryptedData {
    protected String encryptedPin;
    protected String encryptionData;
    protected int keyIndex;
    protected String keySerialNumber;
    protected EncryptionAlgorithm algorithm;

    public EncryptedData(String encryptedPin, int keyIndex, String keySerialNumber, String encryptionData, EncryptionAlgorithm algorithm) {
        this.encryptedPin = encryptedPin;
        this.encryptionData = encryptionData;
        this.keyIndex = keyIndex;
        this.keySerialNumber = keySerialNumber;
        this.algorithm = algorithm;
    }

    public EncryptedData(int[] encryptedPin, int keyIndex, int[] keySerialNumber, int[] encryptionData, EncryptionAlgorithm algorithm) {
        this.encryptedPin = this.hexString(encryptedPin);
        this.encryptionData = this.hexString(encryptionData);
        this.keyIndex = keyIndex;
        this.keySerialNumber = this.hexString(keySerialNumber);
        this.algorithm = algorithm;
    }

    protected String hexString(int[] values) {
        StringBuilder sb = new StringBuilder();
        for (int value : values) {
            if (value > 255) {
                throw new IllegalArgumentException("Value cannot be bigger that 0xFF !");
            }
            String hex = Integer.toHexString(value);
            if (hex.length() == 1) {
                sb.append("0");
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    protected String getEncryptedPin() {
        return this.encryptedPin == null ? "" : this.encryptedPin;
    }

    protected String getEncryptionData() {
        return this.encryptionData == null ? "" : this.encryptionData;
    }

    protected int getKeyIndex() {
        return this.keyIndex;
    }

    protected String getKeySerialNumber() {
        return this.keySerialNumber == null ? "" : this.keySerialNumber;
    }

    protected EncryptionAlgorithm getAlgorithm() {
        return this.algorithm == null ? EncryptionAlgorithm.None : this.algorithm;
    }
}

