/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.error.Error;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EIDStatusResult {
    EIDStatusResult() {
    }

    public Error getError() {
        return this.error();
    }

    public abstract boolean cardInserted();

    public abstract boolean isEIDCard();

    public abstract String language();

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    abstract Error error();

    private static final class CppProxy
    extends EIDStatusResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public boolean cardInserted() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardInserted(this.nativeRef);
        }

        private native boolean native_cardInserted(long var1);

        @Override
        public boolean isEIDCard() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isEIDCard(this.nativeRef);
        }

        private native boolean native_isEIDCard(long var1);

        @Override
        public String language() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_language(this.nativeRef);
        }

        private native String native_language(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);
    }
}

