/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDStatusListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDStatusHelper {
    EIDStatusHelper() {
    }

    public static native EIDStatusHelper create();

    public abstract void getStatus(Terminal var1, EIDStatusListener var2);

    private static final class CppProxy
    extends EIDStatusHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void getStatus(Terminal terminal, EIDStatusListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_getStatus(this.nativeRef, terminal, listener);
        }

        private native void native_getStatus(long var1, Terminal var3, EIDStatusListener var4);
    }
}

