/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDStartSessionListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDStartSessionHelper {
    EIDStartSessionHelper() {
    }

    public static native EIDStartSessionHelper create();

    public abstract void startSession(Terminal var1, EIDStartSessionListener var2);

    private static final class CppProxy
    extends EIDStartSessionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void startSession(Terminal terminal, EIDStartSessionListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_startSession(this.nativeRef, terminal, listener);
        }

        private native void native_startSession(long var1, Terminal var3, EIDStartSessionListener var4);
    }
}

