/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDSignDataListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDSignDataHelper {
    EIDSignDataHelper() {
    }

    public static native EIDSignDataHelper create();

    public abstract void signData(Terminal var1, byte[] var2, String var3, String var4, EIDSignDataListener var5);

    private static final class CppProxy
    extends EIDSignDataHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void signData(Terminal terminal, byte[] dataToSign, String description1, String description2, EIDSignDataListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_signData(this.nativeRef, terminal, dataToSign, description1, description2, listener);
        }

        private native void native_signData(long var1, Terminal var3, byte[] var4, String var5, String var6, EIDSignDataListener var7);
    }
}

