/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDPictureListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDPictureHelper {
    EIDPictureHelper() {
    }

    public static native EIDPictureHelper create();

    public abstract void getPicture(Terminal var1, EIDPictureListener var2);

    private static final class CppProxy
    extends EIDPictureHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void getPicture(Terminal terminal, EIDPictureListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_getPicture(this.nativeRef, terminal, listener);
        }

        private native void native_getPicture(long var1, Terminal var3, EIDPictureListener var4);
    }
}

