/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.error.Error;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EIDEndSessionResult {
    EIDEndSessionResult() {
    }

    public Error getError() {
        return this.error();
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    abstract Error error();

    private static final class CppProxy
    extends EIDEndSessionResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);
    }
}

