/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDEndSessionListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDEndSessionHelper {
    EIDEndSessionHelper() {
    }

    public static native EIDEndSessionHelper create();

    public abstract void endSession(Terminal var1, EIDEndSessionListener var2);

    private static final class CppProxy
    extends EIDEndSessionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void endSession(Terminal terminal, EIDEndSessionListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_endSession(this.nativeRef, terminal, listener);
        }

        private native void native_endSession(long var1, Terminal var3, EIDEndSessionListener var4);
    }
}

