/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.error.Error;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EIDDataResult {
    EIDDataResult() {
    }

    public Error getError() {
        return this.error();
    }

    public abstract String getNationalNumber();

    public abstract String getLastName();

    public abstract String getFirstNames();

    public abstract String getNationality();

    public abstract String getBirthLocation();

    public abstract Date getBirthDate();

    public abstract String getStreetAndNumber();

    public abstract String getZipCode();

    public abstract String getMunicipality();

    public abstract String getCardNumber();

    public abstract Date getCardValidityDateBegin();

    public abstract Date getCardValidityDateEnd();

    public abstract String getCardDeliveryMunicipality();

    public abstract String getFirstLetterOfThirdName();

    public abstract Sex getSex();

    public abstract String getNobleCondition();

    public abstract DocumentType getDocumentType();

    public abstract SpecialStatus getSpecialStatus();

    public abstract byte[] getChipNumber();

    public abstract byte[] getPhotoHash();

    public abstract byte[] getRawIdData();

    public abstract byte[] getRawIdSignature();

    public abstract byte[] getRawAddressData();

    public abstract byte[] getRawAddressSignature();

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    abstract Error error();

    private static final class CppProxy
    extends EIDDataResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public String getNationalNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_nationalNumber(this.nativeRef);
        }

        private native String native_nationalNumber(long var1);

        @Override
        public String getLastName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_lastName(this.nativeRef);
        }

        private native String native_lastName(long var1);

        @Override
        public String getFirstNames() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_firstNames(this.nativeRef);
        }

        private native String native_firstNames(long var1);

        @Override
        public String getNationality() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_nationality(this.nativeRef);
        }

        private native String native_nationality(long var1);

        @Override
        public String getBirthLocation() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_birthLocation(this.nativeRef);
        }

        private native String native_birthLocation(long var1);

        @Override
        public Date getBirthDate() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.getDate(this.native_birthDate(this.nativeRef));
        }

        private native String native_birthDate(long var1);

        @Override
        public String getStreetAndNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_streetAndNumber(this.nativeRef);
        }

        private native String native_streetAndNumber(long var1);

        @Override
        public String getZipCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_zipCode(this.nativeRef);
        }

        private native String native_zipCode(long var1);

        @Override
        public String getMunicipality() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_municipality(this.nativeRef);
        }

        private native String native_municipality(long var1);

        @Override
        public String getCardNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardNumber(this.nativeRef);
        }

        private native String native_cardNumber(long var1);

        @Override
        public Date getCardValidityDateBegin() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.getDate(this.native_cardValidityDateBegin(this.nativeRef));
        }

        private native String native_cardValidityDateBegin(long var1);

        @Override
        public Date getCardValidityDateEnd() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.getDate(this.native_cardValidityDateEnd(this.nativeRef));
        }

        private native String native_cardValidityDateEnd(long var1);

        @Override
        public String getCardDeliveryMunicipality() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardDeliveryMunicipality(this.nativeRef);
        }

        private native String native_cardDeliveryMunicipality(long var1);

        @Override
        public String getFirstLetterOfThirdName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_firstLetterOfThirdName(this.nativeRef);
        }

        private native String native_firstLetterOfThirdName(long var1);

        @Override
        public Sex getSex() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_sex(this.nativeRef);
        }

        private native Sex native_sex(long var1);

        @Override
        public String getNobleCondition() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_nobleCondition(this.nativeRef);
        }

        private native String native_nobleCondition(long var1);

        @Override
        public DocumentType getDocumentType() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_documentType(this.nativeRef);
        }

        private native DocumentType native_documentType(long var1);

        @Override
        public SpecialStatus getSpecialStatus() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_specialStatus(this.nativeRef);
        }

        private native SpecialStatus native_specialStatus(long var1);

        @Override
        public byte[] getChipNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_chipNumber(this.nativeRef);
        }

        private native byte[] native_chipNumber(long var1);

        @Override
        public byte[] getPhotoHash() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_photoHash(this.nativeRef);
        }

        private native byte[] native_photoHash(long var1);

        @Override
        public byte[] getRawIdData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_rawIdData(this.nativeRef);
        }

        private native byte[] native_rawIdData(long var1);

        @Override
        public byte[] getRawIdSignature() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_rawIdSignature(this.nativeRef);
        }

        private native byte[] native_rawIdSignature(long var1);

        @Override
        public byte[] getRawAddressData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_rawAddressData(this.nativeRef);
        }

        private native byte[] native_rawAddressData(long var1);

        @Override
        public byte[] getRawAddressSignature() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_rawAddressSignature(this.nativeRef);
        }

        private native byte[] native_rawAddressSignature(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);

        private Date getDate(String dateString) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
            }
            catch (ParseException ignored) {
                return null;
            }
        }
    }

    public static enum SpecialStatus {
        NoStatus,
        WhiteCane,
        ExtendedMinority,
        WhiteCaneExtendedMinority,
        YellowCane,
        YellowCaneExtendedMinority,
        Unknown;

    }

    public static enum DocumentType {
        BelgianCitizen,
        EuropeanCommunityCitizen,
        NonEuropeanCommunityCitizen,
        BoostrapCard,
        HabilitationCard,
        Unknown;

    }

    public static enum Sex {
        Male,
        Female,
        Unknown;

    }
}

