/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDDataListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDDataHelper {
    EIDDataHelper() {
    }

    public static native EIDDataHelper create();

    public abstract void getData(Terminal var1, EIDDataListener var2);

    private static final class CppProxy
    extends EIDDataHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void getData(Terminal terminal, EIDDataListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_getData(this.nativeRef, terminal, listener);
        }

        private native void native_getData(long var1, Terminal var3, EIDDataListener var4);
    }
}

