/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.eid;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.eid.EIDCertificateListener;
import com.pegusapps.jctep.transaction.eid.EIDCertificateType;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class EIDCertificateHelper {
    EIDCertificateHelper() {
    }

    public static native EIDCertificateHelper create();

    public abstract void getCertificate(Terminal var1, EIDCertificateType var2, EIDCertificateListener var3);

    private static final class CppProxy
    extends EIDCertificateHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void getCertificate(Terminal terminal, EIDCertificateType certType, EIDCertificateListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_getCertificate(this.nativeRef, terminal, certType, listener);
        }

        private native void native_getCertificate(long var1, Terminal var3, EIDCertificateType var4, EIDCertificateListener var5);
    }
}

