/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.cardinfo;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.cardinfo.CardInfoListener;
import com.pegusapps.jctep.transaction.cardinfo.CheckCardValidityListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class CardInfoTransactionHelper {
    CardInfoTransactionHelper() {
    }

    public static native CardInfoTransactionHelper create();

    public abstract void checkCardValidity(Terminal var1, CheckCardValidityListener var2);

    public abstract void cardInfo(Terminal var1, CardInfoListener var2);

    public void cardInfoWithSale(Terminal terminal, CardInfoListener listener) {
        this.cardInfoWithSaleAfter(terminal, listener);
    }

    public void cardInfoWithSale(Terminal terminal, int timeout, CardInfoListener listener) {
        this.cardInfoWithSaleAfterWithTimeout(terminal, timeout, listener);
    }

    abstract void cardInfoWithSaleAfter(Terminal var1, CardInfoListener var2);

    abstract void cardInfoWithSaleAfterWithTimeout(Terminal var1, int var2, CardInfoListener var3);

    private static final class CppProxy
    extends CardInfoTransactionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void checkCardValidity(Terminal terminal, CheckCardValidityListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_checkCardValidity(this.nativeRef, terminal, listener);
        }

        private native void native_checkCardValidity(long var1, Terminal var3, CheckCardValidityListener var4);

        @Override
        public void cardInfo(Terminal terminal, CardInfoListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_cardInfo(this.nativeRef, terminal, listener);
        }

        private native void native_cardInfo(long var1, Terminal var3, CardInfoListener var4);

        @Override
        public void cardInfoWithSaleAfter(Terminal terminal, CardInfoListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_cardInfoWithSaleAfter(this.nativeRef, terminal, listener);
        }

        private native void native_cardInfoWithSaleAfter(long var1, Terminal var3, CardInfoListener var4);

        @Override
        public void cardInfoWithSaleAfterWithTimeout(Terminal terminal, int timeout, CardInfoListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_cardInfoWithSaleAfterWithTimeout(this.nativeRef, terminal, timeout, listener);
        }

        private native void native_cardInfoWithSaleAfterWithTimeout(long var1, Terminal var3, int var4, CardInfoListener var5);
    }
}

