/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.cardinfo;

import com.pegusapps.jctep.error.Error;
import com.pegusapps.jctep.transaction.TimestampHelper;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CardInfoResult {
    CardInfoResult() {
    }

    public Error getError() {
        return this.error();
    }

    public String getClippedPAN() {
        return this.clippedPAN();
    }

    public String getToken() {
        return this.token();
    }

    public abstract boolean isContactless();

    public abstract boolean isMagneticStripe();

    public abstract boolean isIccEmv();

    public abstract boolean isIccNonEmv();

    public abstract boolean isBarCode();

    public abstract boolean isManualEntry();

    public abstract boolean isSynchronousChip();

    public abstract boolean isAsynchronousChip();

    public Date getTimestamp() {
        return TimestampHelper.parseTimestamp(this.timestamp());
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    abstract Error error();

    abstract String clippedPAN();

    abstract String token();

    abstract String timestamp();

    private static final class CppProxy
    extends CardInfoResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public String clippedPAN() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_clippedPAN(this.nativeRef);
        }

        private native String native_clippedPAN(long var1);

        @Override
        public String token() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_token(this.nativeRef);
        }

        private native String native_token(long var1);

        @Override
        public boolean isContactless() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isContactless(this.nativeRef);
        }

        private native boolean native_isContactless(long var1);

        @Override
        public boolean isMagneticStripe() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isMagneticStripe(this.nativeRef);
        }

        private native boolean native_isMagneticStripe(long var1);

        @Override
        public boolean isIccEmv() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isIccEmv(this.nativeRef);
        }

        private native boolean native_isIccEmv(long var1);

        @Override
        public boolean isIccNonEmv() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isIccNonEmv(this.nativeRef);
        }

        private native boolean native_isIccNonEmv(long var1);

        @Override
        public boolean isBarCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isBarCode(this.nativeRef);
        }

        private native boolean native_isBarCode(long var1);

        @Override
        public boolean isManualEntry() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isManualEntry(this.nativeRef);
        }

        private native boolean native_isManualEntry(long var1);

        @Override
        public boolean isSynchronousChip() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isSynchronousChip(this.nativeRef);
        }

        private native boolean native_isSynchronousChip(long var1);

        @Override
        public boolean isAsynchronousChip() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isAsynchronousChip(this.nativeRef);
        }

        private native boolean native_isAsynchronousChip(long var1);

        @Override
        public String timestamp() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_timestamp(this.nativeRef);
        }

        private native String native_timestamp(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);
    }
}

