/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.balance;

import com.pegusapps.jctep.transaction.TimestampHelper;
import com.pegusapps.jctep.transaction.balance.FinancialCounterInfoAccountedServices;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class FinancialCounterInfo {
    FinancialCounterInfo() {
    }

    public String getIdentifier() {
        return this.identifier();
    }

    public String getCurrencyCode() {
        return this.currencyCode();
    }

    public String getName() {
        return this.name();
    }

    public String getCardBrandIdentifier() {
        return this.cardBrandIdentifier();
    }

    public String getCardBrandName() {
        return this.cardBrandName();
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    public int getTransactionsNumber() {
        return this.transactionsNumber();
    }

    public double getCumulativeTotalAmount() {
        return this.cumulativeTotalAmount();
    }

    public String getPeriodNumber() {
        return this.periodNumber();
    }

    public Date getPeriodOpeningDate() {
        return TimestampHelper.parseTimestamp(this.periodOpeningDate());
    }

    public Date getPeriodClosingDate() {
        return TimestampHelper.parseTimestamp(this.periodClosingDate());
    }

    public String getAccountedServicesDescription() {
        return this.accountedServicesDescription();
    }

    public abstract boolean isServiceLinked(FinancialCounterInfoAccountedServices var1);

    abstract String identifier();

    abstract String currencyCode();

    abstract String name();

    abstract String periodNumber();

    abstract String cardBrandIdentifier();

    abstract String cardBrandName();

    abstract String terminalIdentifier();

    abstract String accountedServicesDescription();

    abstract int transactionsNumber();

    abstract double cumulativeTotalAmount();

    abstract String periodOpeningDate();

    abstract String periodClosingDate();

    private static final class CppProxy
    extends FinancialCounterInfo {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public String identifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_identifier(this.nativeRef);
        }

        private native String native_identifier(long var1);

        @Override
        public String currencyCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_currencyCode(this.nativeRef);
        }

        private native String native_currencyCode(long var1);

        @Override
        public String name() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_name(this.nativeRef);
        }

        private native String native_name(long var1);

        @Override
        public String periodNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_periodNumber(this.nativeRef);
        }

        private native String native_periodNumber(long var1);

        @Override
        public String cardBrandIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardBrandIdentifier(this.nativeRef);
        }

        private native String native_cardBrandIdentifier(long var1);

        @Override
        public String cardBrandName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cardBrandName(this.nativeRef);
        }

        private native String native_cardBrandName(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);

        @Override
        public String accountedServicesDescription() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_accountedServicesDescription(this.nativeRef);
        }

        private native String native_accountedServicesDescription(long var1);

        @Override
        public int transactionsNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_transactionsNumber(this.nativeRef);
        }

        private native int native_transactionsNumber(long var1);

        @Override
        public double cumulativeTotalAmount() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_cumulativeTotalAmount(this.nativeRef);
        }

        private native double native_cumulativeTotalAmount(long var1);

        @Override
        public String periodOpeningDate() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_periodOpeningDate(this.nativeRef);
        }

        private native String native_periodOpeningDate(long var1);

        @Override
        public String periodClosingDate() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_periodClosingDate(this.nativeRef);
        }

        private native String native_periodClosingDate(long var1);

        @Override
        public boolean isServiceLinked(FinancialCounterInfoAccountedServices service) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isServiceLinked(this.nativeRef, service);
        }

        private native boolean native_isServiceLinked(long var1, FinancialCounterInfoAccountedServices var3);
    }
}

