/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.balance;

import com.pegusapps.jctep.error.Error;
import com.pegusapps.jctep.transaction.balance.FinancialCounterInfo;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BalanceTerminalConsultationResult {
    BalanceTerminalConsultationResult() {
    }

    public Error getError() {
        return this.error();
    }

    public String getTerminalId() {
        return this.terminalId();
    }

    public String getAcquirerId() {
        return this.acquirerId();
    }

    public String getAcquirerLabelName() {
        return this.acquirerLabelName();
    }

    public List<FinancialCounterInfo> getFinancialCounterInfos() {
        return this.financialCounterInfo();
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    abstract String terminalIdentifier();

    abstract Error error();

    abstract String terminalId();

    abstract String acquirerId();

    abstract String acquirerLabelName();

    abstract List<FinancialCounterInfo> financialCounterInfo();

    private static final class CppProxy
    extends BalanceTerminalConsultationResult {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public Error error() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_error(this.nativeRef);
        }

        private native Error native_error(long var1);

        @Override
        public String terminalId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalId(this.nativeRef);
        }

        private native String native_terminalId(long var1);

        @Override
        public String acquirerId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_acquirerId(this.nativeRef);
        }

        private native String native_acquirerId(long var1);

        @Override
        public String acquirerLabelName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_acquirerLabelName(this.nativeRef);
        }

        private native String native_acquirerLabelName(long var1);

        @Override
        public List<FinancialCounterInfo> financialCounterInfo() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_financialCounterInfo(this.nativeRef);
        }

        private native List<FinancialCounterInfo> native_financialCounterInfo(long var1);

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);
    }
}

