/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.transaction.backupmode;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.transaction.backupmode.BackupModeListener;
import com.pegusapps.jctep.transaction.backupmode.BackupModeStatusListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class BackupModeTransactionHelper {
    BackupModeTransactionHelper() {
    }

    public static native BackupModeTransactionHelper create();

    public abstract void setBackupMode(Terminal var1, boolean var2, BackupModeListener var3);

    public abstract void backupModeStatus(Terminal var1, BackupModeStatusListener var2);

    private static final class CppProxy
    extends BackupModeTransactionHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void setBackupMode(Terminal terminal, boolean on, BackupModeListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setBackupMode(this.nativeRef, terminal, on, listener);
        }

        private native void native_setBackupMode(long var1, Terminal var3, boolean var4, BackupModeListener var5);

        @Override
        public void backupModeStatus(Terminal terminal, BackupModeStatusListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_backupModeStatus(this.nativeRef, terminal, listener);
        }

        private native void native_backupModeStatus(long var1, Terminal var3, BackupModeStatusListener var4);
    }
}

