/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep.error;

import com.pegusapps.jctep.SaleSystemActionIdentifier;
import com.pegusapps.jctep.error.ErrorCauseCode;
import com.pegusapps.jctep.error.ErrorCode;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Error {
    Error() {
    }

    public ErrorCode getCode() {
        return this.code();
    }

    public ErrorCauseCode getCauseCode() {
        return this.causeCode();
    }

    public HashMap<String, String> getExtraInformationData() {
        return this.extraInformationData();
    }

    public String getIncidentCode() {
        return this.incidentCode();
    }

    public String getRejectionCode() {
        return this.rejectionCode();
    }

    public SaleSystemActionIdentifier getOriginalSaleSystemActionIdentifier() {
        return this.originalSaleSystemActionIdentifier();
    }

    public String toString() {
        return this.description();
    }

    abstract ErrorCode code();

    abstract ErrorCauseCode causeCode();

    abstract HashMap<String, String> extraInformationData();

    abstract String incidentCode();

    abstract String rejectionCode();

    abstract String description();

    abstract SaleSystemActionIdentifier originalSaleSystemActionIdentifier();

    private static final class CppProxy
    extends Error {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public ErrorCode code() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_code(this.nativeRef);
        }

        private native ErrorCode native_code(long var1);

        @Override
        public ErrorCauseCode causeCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_causeCode(this.nativeRef);
        }

        private native ErrorCauseCode native_causeCode(long var1);

        @Override
        public HashMap<String, String> extraInformationData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_extraInformationData(this.nativeRef);
        }

        private native HashMap<String, String> native_extraInformationData(long var1);

        @Override
        public String incidentCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_incidentCode(this.nativeRef);
        }

        private native String native_incidentCode(long var1);

        @Override
        public String rejectionCode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_rejectionCode(this.nativeRef);
        }

        private native String native_rejectionCode(long var1);

        @Override
        public String description() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_description(this.nativeRef);
        }

        private native String native_description(long var1);

        @Override
        public SaleSystemActionIdentifier originalSaleSystemActionIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_originalSaleSystemActionIdentifier(this.nativeRef);
        }

        private native SaleSystemActionIdentifier native_originalSaleSystemActionIdentifier(long var1);
    }
}

