/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.TerminalListener;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class TerminalHelper {
    TerminalHelper() {
    }

    public static native TerminalHelper create();

    public abstract void isAlive(Terminal var1, TerminalListener var2);

    private static final class CppProxy
    extends TerminalHelper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void isAlive(Terminal terminal, TerminalListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_isAlive(this.nativeRef, terminal, listener);
        }

        private native void native_isAlive(long var1, Terminal var3, TerminalListener var4);
    }
}

