/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class TerminalEvent {
    TerminalEvent() {
    }

    public String getTerminalIdentifier() {
        return this.terminalIdentifier();
    }

    public String getEventsString() {
        return this.eventsString();
    }

    public String getDescription() {
        return this.description();
    }

    public abstract boolean isEvent(Events var1);

    abstract String terminalIdentifier();

    abstract String eventsString();

    abstract String description();

    private static final class CppProxy
    extends TerminalEvent {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public String terminalIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalIdentifier(this.nativeRef);
        }

        private native String native_terminalIdentifier(long var1);

        @Override
        public String eventsString() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_eventsString(this.nativeRef);
        }

        private native String native_eventsString(long var1);

        @Override
        public String description() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_description(this.nativeRef);
        }

        private native String native_description(long var1);

        @Override
        public boolean isEvent(Events event) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isEvent(this.nativeRef, event);
        }

        private native boolean native_isEvent(long var1, Events var3);
    }

    public static enum Events {
        TERMINAL_IDLE,
        TERMINAL_MAINTENANCE,
        TERMINAL_OUT_OF_ORDER,
        TERMINAL_BUSY,
        CARD_READER_IDLE,
        CARD_READER_OUT_OF_ORDER,
        PIN_ENTRY,
        ADDITIONAL_DATA_ENTRY,
        INSERT_CARD,
        SWIPE_CARD,
        REMOVE_CARD,
        AWAITING_NEXT_CARD,
        SLAVE_CARD,
        CARD_INSERTED,
        CARD_REMOVED,
        BAD_READING,
        AMOUNT_CONFIRMATION,
        CONFIGURATION_CHANGED,
        TRANSACTION_STARTED,
        CURRENCY_SELECTION,
        KEY_PRESSED;

    }
}

