/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.TerminalHelper;
import com.pegusapps.jctep.TerminalListener;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Terminal {
    Terminal() {
    }

    public String getTerminalId() {
        return this.terminalId();
    }

    public String getDeviceType() {
        return this.deviceType();
    }

    public String getModel() {
        return this.model();
    }

    public String getSerialNumber() {
        return this.serialNumber();
    }

    public String getSoftwareVersion() {
        return this.softwareVersion();
    }

    public String getEmvKernelVersion() {
        return this.emvKernelVersion();
    }

    public abstract String getConnectionDescription();

    public boolean isConnected() {
        return this.connected();
    }

    public abstract void resetTransaction();

    public abstract void enableNotifications(boolean var1);

    public void isAlive(TerminalListener listener) {
        TerminalHelper helper = TerminalHelper.create();
        helper.isAlive(this, listener);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Terminal)) {
            return false;
        }
        Terminal other = (Terminal)obj;
        return (other.getTerminalId() == null ? "" : other.getTerminalId()).equals(this.getTerminalId() == null ? "" : this.getTerminalId());
    }

    public int hashCode() {
        return (this.getTerminalId() == null ? "" : this.getTerminalId()).hashCode();
    }

    public String toString() {
        return "{\n\t\"terminalIdentifier\": \"" + this.getTerminalId() + "\", \n\t\"deviceType\": \"" + this.getDeviceType() + "\", \n\t\"model\": \"" + this.getModel() + "\", \n\t\"serialNumber\": \"" + this.getSerialNumber() + "\", \n\t\"softwareVersion\": \"" + this.getSoftwareVersion() + "\", \n\t\"emvKernelVersion\": \"" + this.getEmvKernelVersion() + "\", \n" + this.getConnectionDescriptionForToString() + "}\n";
    }

    private String getConnectionDescriptionForToString() {
        if (this.getConnectionDescription() == null) {
            return "";
        }
        String ret = this.getConnectionDescription().trim();
        if (ret.startsWith("{")) {
            ret = ret.substring(1);
        }
        if (ret.endsWith("}")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return "\t" + ret.trim() + "\n";
    }

    @Deprecated
    public abstract String terminalId();

    @Deprecated
    public abstract String deviceType();

    @Deprecated
    public abstract String model();

    @Deprecated
    public abstract String serialNumber();

    @Deprecated
    public abstract String softwareVersion();

    @Deprecated
    public abstract String emvKernelVersion();

    @Deprecated
    public abstract boolean connected();

    private static final class CppProxy
    extends Terminal {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public String terminalId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalId(this.nativeRef);
        }

        private native String native_terminalId(long var1);

        @Override
        public String deviceType() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_deviceType(this.nativeRef);
        }

        private native String native_deviceType(long var1);

        @Override
        public String model() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_model(this.nativeRef);
        }

        private native String native_model(long var1);

        @Override
        public String serialNumber() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_serialNumber(this.nativeRef);
        }

        private native String native_serialNumber(long var1);

        @Override
        public String softwareVersion() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_softwareVersion(this.nativeRef);
        }

        private native String native_softwareVersion(long var1);

        @Override
        public String emvKernelVersion() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_EMVKernelVersion(this.nativeRef);
        }

        private native String native_EMVKernelVersion(long var1);

        @Override
        public String getConnectionDescription() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getConnectionDescription(this.nativeRef);
        }

        private native String native_getConnectionDescription(long var1);

        @Override
        public boolean connected() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_connected(this.nativeRef);
        }

        private native boolean native_connected(long var1);

        @Override
        public void resetTransaction() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_resetTransaction(this.nativeRef);
        }

        private native void native_resetTransaction(long var1);

        @Override
        public void enableNotifications(boolean enable) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_enableNotifications(this.nativeRef, enable);
        }

        private native void native_enableNotifications(long var1, boolean var3);
    }
}

