/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.CTEPLib;
import com.pegusapps.jctep.Service;
import com.pegusapps.jctep.ServiceListener;
import com.pegusapps.jctep.ServiceListenerIntern;
import com.pegusapps.jctep.ServiceNotificationsListener;
import com.pegusapps.jctep.Terminal;
import com.pegusapps.jctep.TerminalEvent;
import java.util.List;

public class ServiceFactory {
    private static final CTEPLib LIB = CTEPLib.create();

    ServiceFactory() {
    }

    public static List<String> getAvailableSerialPorts() {
        return LIB.availableSerialPorts();
    }

    @Deprecated
    public static Service createService(int serviceListenPort, ServiceListener listener) {
        return ServiceFactory.createTcpIpService(serviceListenPort, listener);
    }

    @Deprecated
    public static Service createService(int serviceListenPort, ServiceListener serviceListener, ServiceNotificationsListener notificationsListener) {
        return ServiceFactory.createTcpIpService(serviceListenPort, serviceListener, notificationsListener);
    }

    public static Service createTcpIpService(int serviceListenPort, final ServiceListener listener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                listener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                listener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                listener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                listener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
            }
        };
        return LIB.makeTcpIpCTEPService(serviceListenPort, internLstn);
    }

    public static Service createTcpIpService(int serviceListenPort, final ServiceListener serviceListener, final ServiceNotificationsListener notificationsListener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                serviceListener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                serviceListener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                serviceListener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                serviceListener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
                notificationsListener.onTerminalEvent(terminalEvent);
            }
        };
        return LIB.makeTcpIpCTEPService(serviceListenPort, internLstn);
    }

    public static Service createSerialService(String serviceListenPort, final ServiceListener listener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                listener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                listener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                listener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                listener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
            }
        };
        return LIB.makeSerialCTEPService(serviceListenPort, internLstn);
    }

    public static Service createSerialService(String serviceListenPort, int baudRate, final ServiceListener listener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                listener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                listener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                listener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                listener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
            }
        };
        return LIB.makeSerialCTEPService(serviceListenPort, baudRate, internLstn);
    }

    public static Service createSerialService(String serviceListenPort, final ServiceListener serviceListener, final ServiceNotificationsListener notificationsListener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                serviceListener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                serviceListener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                serviceListener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                serviceListener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
                notificationsListener.onTerminalEvent(terminalEvent);
            }
        };
        return LIB.makeSerialCTEPService(serviceListenPort, internLstn);
    }

    public static Service createSerialService(String serviceListenPort, int baudRate, final ServiceListener serviceListener, final ServiceNotificationsListener notificationsListener) {
        ServiceListenerIntern internLstn = new ServiceListenerIntern(){

            @Override
            public void onServiceStart() {
                serviceListener.onServiceStart();
            }

            @Override
            public void onServiceStop() {
                serviceListener.onServiceStop();
            }

            @Override
            public void onTerminalConnect(Terminal terminal) {
                serviceListener.onTerminalConnect(terminal);
            }

            @Override
            public void onTerminalDisconnect(Terminal terminal) {
                serviceListener.onTerminalDisconnect(terminal);
            }

            @Override
            public void onTerminalEvent(TerminalEvent terminalEvent) {
                notificationsListener.onTerminalEvent(terminalEvent);
            }
        };
        return LIB.makeSerialCTEPService(serviceListenPort, baudRate, internLstn);
    }

    static Terminal getTerminal(String terminalIdentifier) {
        return LIB.getTerminal(terminalIdentifier);
    }

    static List<Terminal> getConnectedTerminals() {
        return LIB.getConnectedTerminals();
    }

    public static String getLibraryVersion() {
        return LIB.getLibraryVersion();
    }

    public static void cleanup() {
        LIB.release();
    }
}

