/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.Settings;
import com.pegusapps.jctep.Terminal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Service {
    private static List<Service> services_ = new ArrayList<Service>();

    Service() {
        services_.add(this);
    }

    public abstract void startService();

    public abstract void stopService();

    public Settings getSettings() {
        return this.settings();
    }

    public abstract void updateSettings(Settings var1);

    public abstract Terminal getTerminal(String var1);

    public Iterator<Terminal> getConnectedTerminals() {
        return this.connectedTerminals().iterator();
    }

    public static Iterator<Service> getServices() {
        return services_.iterator();
    }

    abstract List<Terminal> connectedTerminals();

    abstract Settings settings();

    private static final class CppProxy
    extends Service {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void startService() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_startService(this.nativeRef);
        }

        private native void native_startService(long var1);

        @Override
        public void stopService() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_stopService(this.nativeRef);
        }

        private native void native_stopService(long var1);

        @Override
        public Settings settings() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_settings(this.nativeRef);
        }

        private native Settings native_settings(long var1);

        @Override
        public void updateSettings(Settings settings) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_updateSettings(this.nativeRef, settings);
        }

        private native void native_updateSettings(long var1, Settings var3);

        @Override
        public Terminal getTerminal(String tid) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getTerminal(this.nativeRef, tid);
        }

        private native Terminal native_getTerminal(long var1, String var3);

        @Override
        public List<Terminal> connectedTerminals() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_connectedTerminals(this.nativeRef);
        }

        private native List<Terminal> native_connectedTerminals(long var1);
    }
}

