/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.DatatypeConverter;

public class SaleSystemActionIdentifier {
    private byte[] bytes = null;

    public SaleSystemActionIdentifier(byte byte1, byte byte2, byte byte3, byte byte4) {
        this.bytes = new byte[]{byte1, byte2, byte3, byte4};
    }

    public SaleSystemActionIdentifier(long value) {
        this.bytes = new byte[4];
        this.bytes[0] = (byte)(value >> 24 & 0xFFL);
        this.bytes[1] = (byte)(value >> 16 & 0xFFL);
        this.bytes[2] = (byte)(value >> 8 & 0xFFL);
        this.bytes[3] = (byte)(value & 0xFFL);
    }

    private SaleSystemActionIdentifier() {
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public long value() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put(this.bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public String toString() {
        return DatatypeConverter.printHexBinary((byte[])this.bytes());
    }

    private static final class CppProxy
    extends SaleSystemActionIdentifier {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public byte[] bytes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_bytes(this.nativeRef);
        }

        private native byte[] native_bytes(long var1);

        @Override
        public long value() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_value(this.nativeRef);
        }

        private native long native_value(long var1);
    }
}

