/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.transaction.TimestampHelper;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RecoveryFile {
    public String getAcquirerId() {
        return this.acquirerId();
    }

    public String getTerminalId() {
        return this.terminalId();
    }

    public String getSchemeId() {
        return this.schemeId();
    }

    public String getBatchId() {
        return this.batchId();
    }

    public Date getClosingDate() {
        return TimestampHelper.parseTimestamp(this.closingDate());
    }

    public String getContent() {
        return this.content();
    }

    public String getFileName() {
        return this.fileName();
    }

    public static native List<RecoveryFile> getRecoveryFiles();

    public static List<RecoveryFile> getRecoveryFiles(String tid) {
        return RecoveryFile.getRecoveryFilesForTID(tid);
    }

    public static void extractRecoveryFiles(String destinationPath, EraseMode eraseMode) {
        int value = 0;
        switch (eraseMode) {
            case ERASE_AFTER_RECOVERY: {
                value = 1;
            }
        }
        RecoveryFile.extractRecoveryFiles(destinationPath, value);
    }

    public static void extractRecoveryFiles(String tid, String destinationPath, EraseMode eraseMode) {
        int value = 0;
        switch (eraseMode) {
            case ERASE_AFTER_RECOVERY: {
                value = 1;
            }
        }
        RecoveryFile.extractRecoveryFilesForTID(tid, destinationPath, value);
    }

    protected static native List<RecoveryFile> getRecoveryFilesForTID(String var0);

    protected static native void extractRecoveryFiles(String var0, int var1);

    protected static native void extractRecoveryFilesForTID(String var0, String var1, int var2);

    protected abstract String acquirerId();

    protected abstract String terminalId();

    protected abstract String schemeId();

    protected abstract String batchId();

    protected abstract String content();

    protected abstract String fileName();

    protected abstract String closingDate();

    private static final class CppProxy
    extends RecoveryFile {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public String acquirerId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_acquirerId(this.nativeRef);
        }

        private native String native_acquirerId(long var1);

        @Override
        public String terminalId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_terminalId(this.nativeRef);
        }

        private native String native_terminalId(long var1);

        @Override
        public String schemeId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_schemeId(this.nativeRef);
        }

        private native String native_schemeId(long var1);

        @Override
        public String batchId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_batchId(this.nativeRef);
        }

        private native String native_batchId(long var1);

        @Override
        public String content() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_content(this.nativeRef);
        }

        private native String native_content(long var1);

        @Override
        public String fileName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_fileName(this.nativeRef);
        }

        private native String native_fileName(long var1);

        @Override
        public String closingDate() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_closingDate(this.nativeRef);
        }

        private native String native_closingDate(long var1);
    }

    public static enum EraseMode {
        ERASE_AFTER_RECOVERY,
        ERASE_NONE;

    }
}

