/*
 * Decompiled with CFR 0.152.
 */
package com.pegusapps.jctep;

import com.pegusapps.jctep.Service;
import com.pegusapps.jctep.ServiceListenerIntern;
import com.pegusapps.jctep.Terminal;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class CTEPLib {
    CTEPLib() {
    }

    private static void loadNativeLibrary() {
        String vendor = System.getProperty("java.vendor");
        if (vendor != null && vendor.toLowerCase().contains("android")) {
            CTEPLib.loadNativeLibraryAndroid();
            return;
        }
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().contains("mac")) {
            CTEPLib.loadNativeLibraryMacOS();
        } else if (osName != null && osName.toLowerCase().contains("win")) {
            CTEPLib.loadNativeLibraryWin();
        } else if (osName != null && osName.toLowerCase().contains("linux")) {
            CTEPLib.loadNativeLibraryLinux();
        }
    }

    private static void loadNativeLibraryAndroid() {
        System.loadLibrary("Qt5Core");
        System.loadLibrary("jeasyctep");
    }

    private static void loadNativeLibraryMacOS() {
        CTEPLib.loadNativeLibraryMacOS64();
    }

    private static void loadNativeLibraryMacOS64() {
        System.loadLibrary("jeasyctep");
    }

    private static void loadNativeLibraryLinux() {
        CTEPLib.loadNativeLibraryLinux64();
    }

    private static void loadNativeLibraryLinux64() {
        System.loadLibrary("jeasyctep");
    }

    private static void loadNativeLibraryWin() {
        String osArch = System.getProperty("os.arch");
        if (osArch != null && osArch.contains("64")) {
            CTEPLib.loadNativeLibraryWin64();
        } else {
            CTEPLib.loadNativeLibraryWin32();
        }
    }

    private static void loadNativeLibraryWin64() {
        System.loadLibrary("jeasyctep");
    }

    private static void loadNativeLibraryWin32() {
        System.loadLibrary("jeasyctep");
    }

    public abstract Service makeTcpIpCTEPService(int var1, ServiceListenerIntern var2);

    public abstract Service makeSerialCTEPService(String var1, ServiceListenerIntern var2);

    public abstract Service makeSerialCTEPService(String var1, int var2, ServiceListenerIntern var3);

    public abstract List<String> availableSerialPorts();

    public abstract Terminal getTerminal(String var1);

    public List<Terminal> getConnectedTerminals() {
        return this.connectedTerminals();
    }

    abstract List<Terminal> connectedTerminals();

    public abstract String getLibraryVersion();

    public static native CTEPLib create();

    public abstract void release();

    static {
        CTEPLib.loadNativeLibrary();
    }

    private static final class CppProxy
    extends CTEPLib {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void release() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_release(this.nativeRef);
        }

        private native void native_release(long var1);

        @Override
        public Service makeTcpIpCTEPService(int serviceListenPort, ServiceListenerIntern listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_makeTcpIpCTEPService(this.nativeRef, serviceListenPort, listener);
        }

        private native Service native_makeTcpIpCTEPService(long var1, int var3, ServiceListenerIntern var4);

        @Override
        public Service makeSerialCTEPService(String serialPort, ServiceListenerIntern listener) {
            return this.native_makeSerialCTEPService(this.nativeRef, serialPort, listener);
        }

        private native Service native_makeSerialCTEPService(long var1, String var3, ServiceListenerIntern var4);

        @Override
        public Service makeSerialCTEPService(String serialPort, int baudRate, ServiceListenerIntern listener) {
            return this.native_makeSerialCTEPService2(this.nativeRef, serialPort, baudRate, listener);
        }

        private native Service native_makeSerialCTEPService2(long var1, String var3, int var4, ServiceListenerIntern var5);

        @Override
        public List<String> availableSerialPorts() {
            return this.native_availableSerialPorts(this.nativeRef);
        }

        private native List<String> native_availableSerialPorts(long var1);

        @Override
        public Terminal getTerminal(String tid) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getTerminal(this.nativeRef, tid);
        }

        private native Terminal native_getTerminal(long var1, String var3);

        @Override
        public List<Terminal> connectedTerminals() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_connectedTerminals(this.nativeRef);
        }

        private native List<Terminal> native_connectedTerminals(long var1);

        @Override
        public String getLibraryVersion() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getLibraryVersion(this.nativeRef);
        }

        private native String native_getLibraryVersion(long var1);
    }
}

