/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.oweb;

import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.omnis.oweb.OAUTH2authority;
import net.omnis.oweb.OAUTH2userInfo;
import org.apache.commons.exec.LogOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWEBSMTP {
    static final int kNotSecure = 0;
    static final int kSecureSSL = 1;
    static final int kSecureSTARTTLS = 2;
    static final int kAuthTypeNone = 0;
    static final int kAuthTypeLOGIN = 1;
    static final int kAuthTypePLAIN = 2;
    static final int kAuthTypeDIGESTMD5 = 4;
    static final int kAuthTypeNTLM = 8;
    static final int kAuthTypeCRAMMD5 = 16;
    static final int kAuthTypeOAUTH2 = 32;
    static File smOauth2Folder;
    static final int kJSONFileDoesNotExist = 10703;
    static final int kAuthenticationFailed = 10710;
    static final int kNeedNewOAUTH2AuthorizationCode = 10800;
    static final String smCharset = "utf-8";
    int mRequestId;
    boolean mRequestAborted;
    boolean mMailShot;
    InternetAddress[] mToRecipients;
    StringBuilder mFailedRecipients;
    String mErrorInfo;
    StringBuffer mLogBuffer;
    String mLog;
    Properties mDefaultProperties;
    Session mSession = null;
    SMTPTransport mTransport = null;
    MimeMessage mMessage;
    String mServer;
    int mServerPort = 0;
    String mUser;
    String mPassword;
    String mRealm;
    String mNTLMDomain;
    String mOAUTH2;
    LinkedHashMap<String, String> mUserProps;
    String mOAUTH2ClientSecret;
    OAUTH2authority mOAUTH2authority;
    OAUTH2userInfo mOAUTH2userInfo;
    String mOAUTH2authorizationCodeURL;

    OWEBSMTP() {
    }

    static String getMimeTypeForFile(String pPath) {
        FileTypeMap map = MimetypesFileTypeMap.getDefaultFileTypeMap();
        String mimeType = map.getContentType(pPath);
        if (mimeType == null || mimeType.length() <= 0) {
            mimeType = "application/octet-string";
        }
        return mimeType;
    }

    static void setOmnisOAUTH2FolderPathname(String pPath) {
        smOauth2Folder = new File(pPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeRequest(int pRequestId, String pServer, int pSecure, int pAuthType, String pUser, String pPassword, String pOAUTH2, String pRealm, String pNTLMDomain, LinkedHashMap<String, String> pUserProps, String pFrom, String pSubject, String pTo, String pCc, String pBcc, int pPriority, LinkedHashMap<String, String> pExtraHeaders, ArrayList<BodyPart> pBodyParts, int pContent, int pTimeout, boolean pDebugLog, String pOAUTH2ClientSecret, int pFlags) {
        this.mServer = pServer;
        this.mUser = pUser;
        this.mPassword = pPassword;
        this.mRealm = pRealm;
        this.mNTLMDomain = pNTLMDomain;
        this.mOAUTH2 = pOAUTH2;
        this.mUserProps = pUserProps;
        this.mOAUTH2ClientSecret = pOAUTH2ClientSecret;
        boolean bl = this.mMailShot = (pFlags & 1) != 0;
        if (this.mMailShot) {
            this.mFailedRecipients = new StringBuilder();
        }
        if (this.mUser == null) {
            this.mUser = "";
        }
        if (this.mPassword == null) {
            this.mPassword = "";
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            int errorCode;
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            this.setRequest(pRequestId);
            this.mErrorInfo = null;
            this.mLog = null;
            this.mLogBuffer = pDebugLog ? new StringBuffer() : null;
            int colonPos = this.mServer.indexOf(58);
            if (colonPos != -1) {
                try {
                    this.mServerPort = new Integer(pServer.substring(colonPos + 1));
                    this.mServer = this.mServer.substring(0, colonPos);
                }
                catch (Exception e) {
                    this.mErrorInfo = "Error parsing server port number: " + e.toString();
                    int n = 10700;
                    this.abortRequest(pRequestId, true);
                    if (this.mLogBuffer != null) {
                        this.mLog = this.mLogBuffer.toString();
                    }
                    currentThread.setContextClassLoader(oldClassLoader);
                    return n;
                }
            }
            this.mDefaultProperties = new Properties();
            if (pDebugLog) {
                this.mDefaultProperties.put("mail.debug", "true");
            }
            if (pSecure == 1) {
                this.mDefaultProperties.put("mail.smtp.ssl.enable", "true");
            } else if (pSecure == 2) {
                this.mDefaultProperties.put("mail.smtp.starttls.enable", "true");
                this.mDefaultProperties.put("mail.smtp.starttls.required", "true");
            }
            if (pTimeout != 0) {
                String timeout = Integer.toString(pTimeout * 1000);
                this.mDefaultProperties.put("mail.smtp.connectiontimeout", timeout);
                this.mDefaultProperties.put("mail.smtp.timeout", timeout);
                this.mDefaultProperties.put("mail.smtp.writetimeout", timeout);
            }
            if ((errorCode = this.buildMessage(pFrom, pSubject, pTo, pCc, pBcc, pPriority, pExtraHeaders, pBodyParts, pContent)) != 0) {
                int n = errorCode;
                return n;
            }
            if (pAuthType == 0) {
                int n = this.sendMessage(pAuthType, false);
                return n;
            }
            boolean oauth2 = (pAuthType & 0x20) != 0;
            int authTypeWithoutOAUTH2 = pAuthType & 0xFFFFFFDF;
            if (!(authTypeWithoutOAUTH2 == 0 || (errorCode = this.sendMessage(authTypeWithoutOAUTH2, false)) != 0 && errorCode == 10710 && oauth2)) {
                int n = errorCode;
                return n;
            }
            int n = this.sendMessage(32, false);
            return n;
        }
        finally {
            this.abortRequest(pRequestId, true);
            if (this.mLogBuffer != null) {
                this.mLog = this.mLogBuffer.toString();
            }
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    private int buildMessage(String pFrom, String pSubject, String pTo, String pCc, String pBcc, int pPriority, LinkedHashMap<String, String> pExtraHeaders, ArrayList<BodyPart> pBodyParts, int pContent) {
        this.mMessage = new MimeMessage((Session)null);
        try {
            if (pFrom != null) {
                this.mMessage.setFrom((Address)new InternetAddress(pFrom));
            } else {
                this.mMessage.setFrom();
            }
            if (pTo != null) {
                this.mToRecipients = InternetAddress.parse((String)pTo, (boolean)false);
                if (!this.mMailShot) {
                    this.mMessage.setRecipients(Message.RecipientType.TO, (Address[])this.mToRecipients);
                }
            }
            if (pCc != null) {
                this.mMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)pCc, (boolean)false));
            }
            if (pBcc != null) {
                this.mMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)pBcc, (boolean)false));
            }
            this.mMessage.setSubject(pSubject, smCharset);
            this.mMessage.addHeader("X-Priority", Integer.toString(pPriority));
            this.mMessage.setHeader("X-Mailer", "Omnis SMTP");
            this.mMessage.setSentDate(new Date());
            this.addExtraHeaders(this.mMessage, pExtraHeaders);
            this.addContent((MimePart)this.mMessage, pContent, pBodyParts);
        }
        catch (Exception e) {
            this.mErrorInfo = e.toString();
            return 10709;
        }
        return 0;
    }

    private int sendMessage(int pAuthType, boolean pRetry) {
        int errorCode;
        boolean refreshOAUTH2AccessTokenAndRetry;
        block17: {
            boolean oauth2;
            Properties props = new Properties(this.mDefaultProperties);
            this.setAuthProps(props, pAuthType);
            this.addUserProperties(props);
            boolean bl = oauth2 = !pRetry && (pAuthType & 0x20) != 0 && this.mOAUTH2 != null && this.mOAUTH2.length() > 0;
            if (oauth2) {
                int errorCode2 = this.handleOAUTH2();
                if (errorCode2 != 0) {
                    return errorCode2;
                }
                this.mPassword = this.mOAUTH2userInfo.mAccessToken;
            }
            this.mSession = Session.getInstance((Properties)props, null);
            if (this.mLogBuffer != null) {
                this.mSession.setDebug(true);
                LogOutputStream losStdOut = new LogOutputStream(){

                    protected void processLine(String line, int level) {
                        OWEBSMTP.this.mLogBuffer.append(line);
                        OWEBSMTP.this.mLogBuffer.append("\r\n");
                    }
                };
                this.mSession.setDebugOut(new PrintStream((OutputStream)losStdOut));
            }
            refreshOAUTH2AccessTokenAndRetry = false;
            try {
                errorCode = this.doConnectAndSend();
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            catch (MessagingException e) {
                this.mErrorInfo = e.toString();
                if (e instanceof AuthenticationFailedException) {
                    if (oauth2 && !this.mOAUTH2userInfo.mHaveRefreshedToken) {
                        if (this.mOAUTH2userInfo.mRefreshToken != null) {
                            refreshOAUTH2AccessTokenAndRetry = true;
                        } else {
                            return 10800;
                        }
                    }
                    if (!refreshOAUTH2AccessTokenAndRetry) {
                        return 10710;
                    }
                }
                if (refreshOAUTH2AccessTokenAndRetry) break block17;
                return 10701;
            }
        }
        if (refreshOAUTH2AccessTokenAndRetry) {
            errorCode = this.mOAUTH2userInfo.refreshAccessToken();
            if (errorCode != 0) {
                return errorCode;
            }
            this.mPassword = this.mOAUTH2userInfo.mAccessToken;
            try {
                errorCode = this.doConnectAndSend();
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            catch (MessagingException e) {
                if (e instanceof AuthenticationFailedException) {
                    return 10800;
                }
                this.mErrorInfo = e.toString();
                return 10701;
            }
        }
        return 0;
    }

    private int doConnectAndSend() throws MessagingException {
        this.mTransport = (SMTPTransport)this.mSession.getTransport("smtp");
        if (this.mServerPort != 0) {
            this.mTransport.connect(this.mServer, this.mServerPort, this.mUser, this.mPassword);
        } else {
            this.mTransport.connect(this.mServer, this.mUser, this.mPassword);
        }
        if (this.mRequestAborted) {
            return -1;
        }
        if (this.mMailShot) {
            for (int i = 0; i < this.mToRecipients.length; ++i) {
                InternetAddress address = this.mToRecipients[i];
                this.mMessage.setRecipient(Message.RecipientType.TO, (Address)address);
                try {
                    this.mTransport.sendMessage((Message)this.mMessage, this.mMessage.getAllRecipients());
                    continue;
                }
                catch (SendFailedException e) {
                    Address[] invalidAddresses = e.getInvalidAddresses();
                    if (invalidAddresses != null && invalidAddresses.length > 0) {
                        this.addAddressToFailedRecipients(invalidAddresses[0].toString(), 10717, e.toString());
                        continue;
                    }
                    Address[] unsentAddresses = e.getValidUnsentAddresses();
                    if (unsentAddresses != null && unsentAddresses.length > 0) {
                        this.addAddressToFailedRecipients(unsentAddresses[0].toString(), 10718, e.toString());
                        continue;
                    }
                    this.addAddressToFailedRecipients(address.toString(), 10719, e.toString());
                    continue;
                }
                catch (MessagingException e) {
                    this.addAddressToFailedRecipients(address.toString(), 10720, e.toString());
                }
            }
        } else {
            this.mTransport.sendMessage((Message)this.mMessage, this.mMessage.getAllRecipients());
        }
        if (this.mRequestAborted) {
            return -1;
        }
        return 0;
    }

    void addAddressToFailedRecipients(String pAddress, int pErrorCode, String pNativeErrorText) {
        this.mFailedRecipients.append(pAddress);
        this.mFailedRecipients.append('\u0000');
        this.mFailedRecipients.append(pErrorCode);
        this.mFailedRecipients.append('\u0000');
        this.mFailedRecipients.append(pNativeErrorText);
        this.mFailedRecipients.append('\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessTokenAndRetry(int pRequestId, String pAuthorizationCode) {
        int errorCode;
        this.setRequest(pRequestId);
        if (this.mLogBuffer != null) {
            this.mLogBuffer.setLength(0);
        }
        if ((errorCode = this.mOAUTH2userInfo.getAccessToken(pAuthorizationCode)) != 0) {
            this.mErrorInfo = this.mOAUTH2userInfo.mErrorInfo;
            return errorCode;
        }
        this.mPassword = this.mOAUTH2userInfo.mAccessToken;
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            errorCode = this.sendMessage(32, true);
        }
        catch (Exception e) {
            this.mErrorInfo = e.toString();
            errorCode = 10701;
        }
        finally {
            this.abortRequest(pRequestId, true);
            if (this.mLogBuffer != null) {
                this.mLog = this.mLogBuffer.toString();
            }
            currentThread.setContextClassLoader(oldClassLoader);
        }
        return errorCode;
    }

    String getFailedMailshotRecipients() {
        if (!this.mMailShot) {
            return null;
        }
        this.mFailedRecipients.append('\u0000');
        return this.mFailedRecipients.toString();
    }

    private synchronized void setRequest(int pRequestId) {
        this.mRequestId = pRequestId;
        this.mRequestAborted = false;
    }

    synchronized void clearRequestId(int pRequestId) {
        if (!this.mRequestAborted && pRequestId == this.mRequestId) {
            this.mRequestAborted = true;
            this.mRequestId = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortRequest(int pRequestId, boolean pNormalClose) {
        this.clearRequestId(pRequestId);
        if (this.mTransport != null) {
            try {
                if (!pNormalClose) {
                    Field f = this.mTransport.getClass().getDeclaredField("serverSocket");
                    f.setAccessible(true);
                    Socket s = (Socket)f.get(this.mTransport);
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (Exception e) {
                this.mTransport = null;
            }
            finally {
                try {
                    this.mTransport.close();
                }
                catch (Exception exception) {}
                this.mTransport = null;
            }
        }
    }

    private void setAuthProps(Properties pProps, int pAuthType) {
        boolean oauth2;
        this.mOAUTH2userInfo = null;
        this.mOAUTH2authority = null;
        if (pAuthType == 0) {
            return;
        }
        pProps.put("mail.smtp.auth", "true");
        StringBuilder mechanisms = new StringBuilder();
        this.checkAuthType(pProps, pAuthType, 4, "mail.smtp.auth.digest-md5.disable", "DIGEST-MD5", mechanisms);
        this.checkAuthType(pProps, pAuthType, 1, "mail.smtp.auth.login.disable", "LOGIN", mechanisms);
        this.checkAuthType(pProps, pAuthType, 2, "mail.smtp.auth.plain.disable", "PLAIN", mechanisms);
        this.checkAuthType(pProps, pAuthType, 8, "mail.smtp.auth.ntlm.disable", "NTLM", mechanisms);
        if (mechanisms.length() > 0) {
            pProps.put("mail.smtp.auth.mechanisms", mechanisms.toString());
        }
        if ((pAuthType & 4) != 0 && this.mRealm != null) {
            pProps.put("mail.smtp.sasl.realm", this.mRealm);
        }
        if ((pAuthType & 8) != 0 && this.mNTLMDomain != null) {
            pProps.put("mail.smtp.auth.ntlm.domain", this.mNTLMDomain);
        }
        boolean crammd5 = (pAuthType & 0x10) != 0;
        boolean bl = oauth2 = (pAuthType & 0x20) != 0;
        if (crammd5 || oauth2) {
            pProps.put("mail.smtp.sasl.enable", "true");
            if (crammd5) {
                pProps.put("mail.smtp.sasl.mechanisms", "CRAM-MD5");
            } else {
                pProps.put("mail.smtp.sasl.mechanisms", "XOAUTH2");
            }
        }
    }

    private void checkAuthType(Properties pProps, int pAuthType, int pFlagToCheck, String pDisableProperty, String pMechanism, StringBuilder pMechanisms) {
        if ((pAuthType & pFlagToCheck) != 0) {
            if (pMechanisms.length() > 0) {
                pMechanisms.append(' ');
            }
            pMechanisms.append(pMechanism);
        } else {
            pProps.put(pDisableProperty, "true");
        }
    }

    private int handleOAUTH2() {
        if (this.mOAUTH2 == null || this.mOAUTH2.length() == 0) {
            return 10702;
        }
        this.mOAUTH2authority = new OAUTH2authority(this.mOAUTH2, this.mUser, this.mOAUTH2ClientSecret);
        if (this.mOAUTH2authority.mErrorCode != 0) {
            this.mErrorInfo = this.mOAUTH2authority.mErrorInfo;
            return this.mOAUTH2authority.mErrorCode;
        }
        this.mOAUTH2authorizationCodeURL = this.mOAUTH2authority.mAuthorizationCodeURL;
        this.mOAUTH2userInfo = new OAUTH2userInfo(this.mOAUTH2authority, this.mOAUTH2, this.mUser);
        if (this.mOAUTH2userInfo.mErrorCode != 0) {
            this.mErrorInfo = this.mOAUTH2userInfo.mErrorInfo;
            return this.mOAUTH2userInfo.mErrorCode;
        }
        return 0;
    }

    private void addUserProperties(Properties pProps) {
        if (this.mUserProps != null) {
            Set<String> propNames = this.mUserProps.keySet();
            for (String key : propNames) {
                if (key == null || key.length() <= 0) continue;
                String value = this.mUserProps.get(key);
                if (value == null) {
                    value = "";
                }
                pProps.put(key, value);
            }
        }
    }

    private void addExtraHeaders(MimeMessage pMsg, LinkedHashMap<String, String> pExtraHeaders) throws MessagingException {
        if (pExtraHeaders != null) {
            Set<String> hdrNames = pExtraHeaders.keySet();
            for (String key : hdrNames) {
                if (key == null || key.length() <= 0) continue;
                String value = pExtraHeaders.get(key);
                if (value == null) {
                    value = "";
                }
                pMsg.addHeader(key, value);
            }
        }
    }

    private void addContent(MimePart pMsg, int pContent, ArrayList<BodyPart> pBodyParts) throws MessagingException {
        BodyPart rootBp = pBodyParts.get(pContent - 1);
        if (rootBp.mPartType == 4) {
            this.setMultiBodyPart(pMsg, rootBp, pBodyParts);
        } else if (rootBp.mPartType == 1) {
            this.setSingleFileBodyPart(pMsg, rootBp);
        } else {
            this.setSingleDataBodyPart(pMsg, rootBp);
        }
    }

    private void setMultiBodyPart(MimePart pMsgBodyPart, BodyPart pBodyPart, ArrayList<BodyPart> pBodyParts) throws MessagingException {
        MimeMultipart mp = new MimeMultipart(pBodyPart.mDisposition);
        for (int i = 0; i < pBodyPart.mParts.length; ++i) {
            MimeBodyPart mbp = new MimeBodyPart();
            this.addContent((MimePart)mbp, pBodyPart.mParts[i], pBodyParts);
            mp.addBodyPart((javax.mail.BodyPart)mbp);
        }
        pMsgBodyPart.setContent((Multipart)mp);
    }

    private void setSingleFileBodyPart(MimePart pMsgBodyPart, BodyPart pBodyPart) throws MessagingException {
        FileDataSource ds = new FileDataSource(pBodyPart.mPath);
        pMsgBodyPart.setDataHandler(new DataHandler((DataSource)ds));
        this.setSingleBodyPartInfo(pMsgBodyPart, pBodyPart);
    }

    private void setSingleDataBodyPart(MimePart pMsgBodyPart, BodyPart pBodyPart) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(pBodyPart.mData, pBodyPart.mMIMEtype);
        pMsgBodyPart.setDataHandler(new DataHandler((DataSource)ds));
        this.setSingleBodyPartInfo(pMsgBodyPart, pBodyPart);
    }

    private void setSingleBodyPartInfo(MimePart pMsgBodyPart, BodyPart pBodyPart) throws MessagingException {
        if (pBodyPart.mCharset != null) {
            pMsgBodyPart.addHeader("Content-Type", pBodyPart.mMIMEtype + "; charset=" + pBodyPart.mCharset);
        } else {
            pMsgBodyPart.addHeader("Content-Type", pBodyPart.mMIMEtype);
        }
        if (pBodyPart.mEncoding != null) {
            pMsgBodyPart.addHeader("Content-Transfer-Encoding", pBodyPart.mEncoding);
        }
        if (pBodyPart.mDisposition != null) {
            pMsgBodyPart.setDisposition(pBodyPart.mDisposition);
        }
        if (pBodyPart.mFilename != null) {
            pMsgBodyPart.setFileName(pBodyPart.mFilename);
        }
    }

    static class BodyPart {
        static final int kPartTypeFile = 1;
        static final int kPartTypeChar = 2;
        static final int kPartTypeBin = 3;
        static final int kPartTypeMulti = 4;
        int mPartType;
        String mMIMEtype;
        String mEncoding;
        String mCharset;
        String mDisposition;
        String mPath;
        String mFilename;
        byte[] mData;
        int[] mParts;

        BodyPart(int pPartType, String pMIMEtype, String pEncoding, String pCharset, String pDisposition, String pPath, String pFilename, byte[] pData, int[] pParts) {
            this.mPartType = pPartType;
            this.mMIMEtype = pMIMEtype;
            this.mEncoding = pEncoding;
            this.mCharset = pCharset;
            this.mDisposition = pDisposition;
            this.mPath = pPath;
            this.mFilename = pFilename;
            this.mData = pData;
            this.mParts = pParts;
        }
    }
}

