/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.oweb;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Base64;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EntityUtils;

public class OWEBHTTP {
    static final int kHttpMethodDelete = 0;
    static final int kHttpMethodGet = 1;
    static final int kHttpMethodHead = 2;
    static final int kHttpMethodOptions = 3;
    static final int kHttpMethodPatch = 4;
    static final int kHttpMethodPost = 5;
    static final int kHttpMethodPut = 6;
    static final int kHttpMethodTrace = 7;
    static final int kAuthTypeNone = 0;
    static final int kAuthTypeBasic = 1;
    static final int kAuthTypeDigest = 2;
    static final int kAuthTypeBasicPreemptive = 3;
    boolean mUseConnectionManager;
    static PoolingClientConnectionManager smConnectionManager;
    static boolean smUseCommonsChunked;
    DefaultHttpClient mHttpClient;
    BasicHttpContext mContext = new BasicHttpContext();
    int mLastAuthenticationType = 0;
    HttpRequestBase mRequest;
    boolean mRequestAborted = false;
    int mRequestId;
    int mStatusCode;
    String mStatusText;
    String mErrorInfo;
    byte[] mResponseContent;
    org.apache.http.Header[] mResponseHeaders;
    Header[] mTrailers;
    boolean mFailedToCreateKeyStore = false;
    boolean mFailedToCreateProxyHost = false;

    OWEBHTTP(String pProxyServerURI, boolean pUseConnectionManager, int pTimeoutInSeconds, String pKeyStorePath, String pKeyStorePassword) {
        this.mUseConnectionManager = pUseConnectionManager;
        if (this.mUseConnectionManager) {
            OWEBHTTP.checkConnectionManager();
        }
        HttpHost proxyHost = null;
        if (pProxyServerURI != null && (proxyHost = this.getHostFromURI(this.checkURIHasScheme(pProxyServerURI))) == null) {
            this.mFailedToCreateProxyHost = true;
        }
        if (this.mUseConnectionManager) {
            this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)smConnectionManager);
        } else if (pKeyStorePath != null) {
            if (pKeyStorePassword == null) {
                pKeyStorePassword = "";
            }
            KeyStore keystore = null;
            try {
                keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream keystoreInput = new FileInputStream(pKeyStorePath);
                keystore.load(keystoreInput, pKeyStorePassword.toCharArray());
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                SSLSocketFactory lSchemeSocketFactory = new SSLSocketFactory(keystore, pKeyStorePassword);
                schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)lSchemeSocketFactory));
                this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager(schemeRegistry));
            }
            catch (Exception e) {
                this.mFailedToCreateKeyStore = true;
                return;
            }
        } else {
            this.mHttpClient = new DefaultHttpClient();
        }
        HttpParams params = this.mHttpClient.getParams();
        params.setParameter("http.protocol.allow-circular-redirects", (Object)true);
        if (proxyHost != null) {
            params.setParameter("http.route.default-proxy", (Object)proxyHost);
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(pTimeoutInSeconds *= 1000));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)pTimeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeRequest(int pRequestId, String pURI, int pMethod, String[] pHeaderNames, String[] pHeaderValues, byte[] pContent, int pAuthenticationType, String pUser, String pPassword, String pRealm) {
        if (this.mFailedToCreateProxyHost) {
            return 10605;
        }
        if (this.mFailedToCreateKeyStore) {
            return 10606;
        }
        this.mErrorInfo = "";
        this.mResponseContent = null;
        this.mResponseHeaders = null;
        this.mTrailers = null;
        this.mStatusCode = 0;
        this.mStatusText = "";
        pURI = this.checkURIHasScheme(pURI);
        if (pContent != null && pMethod != 5 && pMethod != 6 && pMethod != 4) {
            return 10602;
        }
        HttpRequestBase httpRequest = null;
        try {
            int authError;
            httpRequest = this.getRequest(pMethod, pURI, pContent);
            if (httpRequest == null) {
                int n = 10600;
                return n;
            }
            this.setRequest(httpRequest, pRequestId);
            if (pHeaderNames != null && pHeaderValues != null) {
                for (int i = 0; i < pHeaderNames.length; ++i) {
                    httpRequest.addHeader(pHeaderNames[i], pHeaderValues[i]);
                }
            }
            if ((authError = this.setupAuthentication(httpRequest, pURI, pAuthenticationType, pUser, pPassword, pRealm)) != 0) {
                int n = authError;
                return n;
            }
            HttpResponse response = this.mHttpClient.execute((HttpUriRequest)httpRequest, (HttpContext)this.mContext);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                this.mResponseContent = EntityUtils.toByteArray((HttpEntity)entity);
                if (smUseCommonsChunked && entity.isChunked() && this.mResponseContent != null && this.mResponseContent.length > 0) {
                    ByteArrayInputStream bs = new ByteArrayInputStream(this.mResponseContent);
                    GetMethod m = new GetMethod();
                    ChunkedInputStream cis = new ChunkedInputStream((InputStream)bs, (HttpMethod)m);
                    ByteArrayBuffer baBuf = new ByteArrayBuffer(this.mResponseContent.length);
                    int cur = 0;
                    byte[] buf = new byte[4096];
                    while ((cur = cis.read(buf)) != -1) {
                        baBuf.append(buf, 0, cur);
                    }
                    this.mResponseContent = baBuf.toByteArray();
                    bs.close();
                    this.mTrailers = m.getResponseFooters();
                    cis.close();
                }
            }
            StatusLine status = response.getStatusLine();
            this.mStatusCode = status.getStatusCode();
            this.mStatusText = status.getReasonPhrase();
            this.mResponseHeaders = response.getAllHeaders();
            if (this.mTrailers != null && this.mTrailers.length > 0) {
                org.apache.http.Header[] trailers = new org.apache.http.Header[this.mTrailers.length];
                for (int i = 0; i < this.mTrailers.length; ++i) {
                    trailers[i] = new BasicHeader(this.mTrailers[i].getName(), this.mTrailers[i].getValue());
                }
                this.mResponseHeaders = (org.apache.http.Header[])ArrayUtils.addAll((Object[])this.mResponseHeaders, (Object[])trailers);
            }
        }
        catch (Exception e) {
            if (httpRequest != null) {
                httpRequest.abort();
            }
            if (!this.mRequestAborted) {
                Throwable cause = e.getCause();
                this.mErrorInfo = cause != null ? cause.toString() : e.getLocalizedMessage();
                int n = 10601;
                return n;
            }
        }
        finally {
            this.setRequest(null, 0);
        }
        return 0;
    }

    private HttpRequestBase getRequest(int pMethod, String pURI, byte[] pContent) {
        switch (pMethod) {
            case 0: {
                return new HttpDelete(pURI);
            }
            case 1: {
                return new HttpGet(pURI);
            }
            case 2: {
                return new HttpHead(pURI);
            }
            case 3: {
                return new HttpOptions(pURI);
            }
            case 4: {
                HttpPatch patch = new HttpPatch(pURI);
                patch.setEntity((HttpEntity)new ByteArrayEntity(pContent));
                return patch;
            }
            case 5: {
                HttpPost post = new HttpPost(pURI);
                post.setEntity((HttpEntity)new ByteArrayEntity(pContent));
                return post;
            }
            case 6: {
                HttpPut put = new HttpPut(pURI);
                put.setEntity((HttpEntity)new ByteArrayEntity(pContent));
                return put;
            }
            case 7: {
                return new HttpTrace(pURI);
            }
        }
        return null;
    }

    private String checkURIHasScheme(String pURI) {
        if (pURI.indexOf("http://") == -1 && pURI.indexOf("https://") == -1) {
            return "http://" + pURI;
        }
        return pURI;
    }

    private HttpHost getHostFromURI(String pURI) {
        HttpHost host;
        try {
            host = URIUtils.extractHost((URI)new URI(pURI));
        }
        catch (URISyntaxException e) {
            this.mErrorInfo = e.getMessage();
            return null;
        }
        return host;
    }

    private int setupAuthentication(HttpRequestBase pRequest, String pURI, int pAuthenticationType, String pUser, String pPassword, String pRealm) {
        if (pAuthenticationType != 0) {
            HttpHost host = this.getHostFromURI(pURI);
            if (host == null) {
                return 10604;
            }
            this.mHttpClient.getCredentialsProvider().setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(pUser, pPassword));
            if (this.mLastAuthenticationType != pAuthenticationType) {
                this.mContext.setAttribute("http.auth.auth-cache", null);
            }
            if (pAuthenticationType == 2) {
                BasicAuthCache authCache = new BasicAuthCache();
                DigestScheme digestAuth = new DigestScheme();
                if (pRealm != null && pRealm.length() > 0) {
                    digestAuth.overrideParamter("realm", pRealm);
                }
                authCache.put(host, (AuthScheme)digestAuth);
                this.mContext.setAttribute("http.auth.auth-cache", (Object)authCache);
            } else if (pAuthenticationType == 3) {
                String auth = pUser + ":" + pPassword;
                byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(Charset.forName("ISO-8859-1")));
                String authHeader = "Basic " + new String(encodedAuth);
                pRequest.setHeader("Authorization", authHeader);
            }
        }
        this.mLastAuthenticationType = pAuthenticationType;
        return 0;
    }

    private synchronized void setRequest(HttpRequestBase pRequest, int pRequestId) {
        this.mRequest = pRequest;
        this.mRequestId = pRequestId;
        this.mRequestAborted = false;
    }

    synchronized void abortRequest(int pRequestId, boolean pNormalClose) {
        if (this.mRequest != null && !this.mRequestAborted && pRequestId == this.mRequestId) {
            this.mRequest.abort();
            this.mRequestAborted = true;
            this.mRequestId = 0;
        }
    }

    private static synchronized void checkConnectionManager() {
        if (smConnectionManager == null) {
            smConnectionManager = new PoolingClientConnectionManager();
            smConnectionManager.setMaxTotal(256);
        }
    }

    static {
        smUseCommonsChunked = false;
    }
}

