/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.oweb;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.omnis.oweb.JSONFile;
import net.omnis.oweb.OAUTH2authority;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class OAUTH2userInfo
extends JSONFile {
    static final String kExpires = "expires";
    static final String kAccessToken = "accessToken";
    static final String kRefreshToken = "refreshToken";
    OAUTH2authority mAuthority;
    String mAccessToken;
    long mExpires;
    String mRefreshToken;
    boolean mHaveRefreshedToken = false;
    BasicHttpContext mContext;
    DefaultHttpClient mHttpClient;
    static PoolingClientConnectionManager smConnectionManager;

    OAUTH2userInfo(OAUTH2authority pAuthority, String pAuthorityDir, String pUser) {
        super(pAuthorityDir, pUser.concat(".info"));
        this.mAuthority = pAuthority;
        if (this.mErrorCode == 10703) {
            this.mErrorInfo = null;
            this.mErrorCode = 10800;
            return;
        }
        if (this.mErrorCode != 0) {
            return;
        }
        String expires = (String)this.mJSON.get((Object)kExpires);
        this.mAccessToken = (String)this.mJSON.get((Object)kAccessToken);
        this.mRefreshToken = (String)this.mJSON.get((Object)kRefreshToken);
        if (expires == null || this.mAccessToken == null || this.mRefreshToken == null || expires.length() == 0 || this.mAccessToken.length() == 0 || this.mRefreshToken.length() == 0) {
            this.mErrorCode = 10800;
            return;
        }
        this.mExpires = new Long(expires);
        Date now = new Date();
        if (this.mExpires < now.getTime()) {
            this.mErrorCode = this.refreshAccessToken();
            return;
        }
    }

    int getAccessToken(String pAuthorizationCode) {
        this.prepareForHttp();
        UrlEncodedFormEntity entity = this.mAuthority.getAccessTokenPostEntity(pAuthorizationCode);
        if (entity == null) {
            return 10712;
        }
        return this.postTokenEntity(entity);
    }

    int refreshAccessToken() {
        this.prepareForHttp();
        UrlEncodedFormEntity entity = this.mAuthority.getRefreshTokenPostEntity(this.mRefreshToken);
        if (entity == null) {
            return 10713;
        }
        return this.postTokenEntity(entity);
    }

    private void prepareForHttp() {
        if (this.mHttpClient != null) {
            return;
        }
        OAUTH2userInfo.checkConnectionManager();
        this.mContext = new BasicHttpContext();
        this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)smConnectionManager);
        if (this.mAuthority.mProxyServer != null && this.mAuthority.mProxyServer.length() > 0) {
            HttpParams params = this.mHttpClient.getParams();
            params.setParameter("http.route.default-proxy", (Object)this.mAuthority.mProxyServer);
        }
    }

    private int postTokenEntity(UrlEncodedFormEntity pEntity) {
        HttpPost post = new HttpPost(this.mAuthority.mTokenURL);
        post.setEntity((HttpEntity)pEntity);
        post.setHeader("content-type", "application/x-www-form-urlencoded");
        try {
            HttpResponse response = this.mHttpClient.execute((HttpUriRequest)post, (HttpContext)this.mContext);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return 10715;
            }
            byte[] responseContent = EntityUtils.toByteArray((HttpEntity)entity);
            JSONObject json = (JSONObject)JSONValue.parseWithException((byte[])responseContent);
            this.mAccessToken = (String)json.get((Object)"access_token");
            String refreshToken = (String)json.get((Object)"refresh_token");
            if (refreshToken != null) {
                this.mRefreshToken = refreshToken;
            }
            long expiresIn = ((Integer)json.get((Object)"expires_in")).intValue();
            Date now = new Date();
            this.mExpires = now.getTime() + 1000L * expiresIn;
            this.writeUserInfoFile();
        }
        catch (Exception e) {
            this.mErrorInfo = e.toString();
            return 10714;
        }
        return 0;
    }

    private void writeUserInfoFile() throws UnsupportedEncodingException, IOException {
        JSONObject mainObj = new JSONObject();
        mainObj.put((Object)kAccessToken, (Object)this.mAccessToken);
        mainObj.put((Object)kExpires, (Object)Long.toString(this.mExpires));
        mainObj.put((Object)kRefreshToken, (Object)this.mRefreshToken);
        FileOutputStream fos = new FileOutputStream(this.mJSONFile);
        fos.write(mainObj.toString().getBytes("utf-8"));
        fos.close();
    }

    private static synchronized void checkConnectionManager() {
        if (smConnectionManager == null) {
            smConnectionManager = new PoolingClientConnectionManager();
            smConnectionManager.setMaxTotal(256);
        }
    }
}

