/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.oweb;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import net.omnis.oweb.JSONFile;
import net.omnis.oweb.URLUTF8Encoder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class OAUTH2authority
extends JSONFile {
    static final String kAuthURL = "authURL";
    static final String kTokenURL = "tokenURL";
    static final String kProxyServer = "proxyServer";
    static final String kScope = "scope";
    static final String kRedirectURI = "redirectURI";
    static final String kClientID = "clientID";
    static final String kClientSecret = "clientSecret";
    String mClientSecret;
    String mAuthURL;
    String mTokenURL;
    String mProxyServer;
    String mScope;
    String mRedirectURI;
    String mClientID;
    String mAuthorizationCodeURL;

    OAUTH2authority(String pAuthorityDir, String pUser, String pClientSecret) {
        super(pAuthorityDir, "config.json");
        if (this.mErrorCode != 0) {
            return;
        }
        this.mAuthURL = (String)this.mJSON.get((Object)kAuthURL);
        this.mTokenURL = (String)this.mJSON.get((Object)kTokenURL);
        this.mProxyServer = (String)this.mJSON.get((Object)kProxyServer);
        this.mScope = (String)this.mJSON.get((Object)kScope);
        this.mRedirectURI = (String)this.mJSON.get((Object)kRedirectURI);
        this.mClientID = (String)this.mJSON.get((Object)kClientID);
        this.mClientSecret = pClientSecret != null && pClientSecret.length() > 0 ? pClientSecret : (String)this.mJSON.get((Object)kClientSecret);
        if (this.mAuthURL == null || this.mTokenURL == null || this.mProxyServer == null || this.mScope == null || this.mRedirectURI == null || this.mClientID == null) {
            this.mErrorCode = 10707;
            return;
        }
        if (this.mAuthURL.length() == 0 || this.mTokenURL.length() == 0 || this.mScope.length() == 0 || this.mRedirectURI.length() == 0 || this.mClientID.length() == 0) {
            this.mErrorCode = 10707;
            return;
        }
        StringBuilder sb = new StringBuilder(this.mAuthURL);
        sb.append('?');
        this.addUriParameter(sb, "client_id", this.mClientID, false);
        this.addUriParameter(sb, "redirect_uri", this.mRedirectURI, false);
        this.addUriParameter(sb, "response_type", "code", false);
        this.addUriParameter(sb, kScope, this.mScope, false);
        this.addUriParameter(sb, "login_hint", pUser, true);
        this.mAuthorizationCodeURL = sb.toString();
    }

    private void addUriParameter(StringBuilder pUri, String pName, String pValue, boolean pIsLast) {
        URLUTF8Encoder.encode(pUri, pName);
        pUri.append('=');
        URLUTF8Encoder.encode(pUri, pValue);
        if (!pIsLast) {
            pUri.append('&');
        }
    }

    UrlEncodedFormEntity getAccessTokenPostEntity(String pAuthorizationCode) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        try {
            nameValuePairs.add(new BasicNameValuePair("code", pAuthorizationCode));
            nameValuePairs.add(new BasicNameValuePair("client_id", this.mClientID));
            nameValuePairs.add(new BasicNameValuePair("client_secret", this.mClientSecret));
            nameValuePairs.add(new BasicNameValuePair("redirect_uri", this.mRedirectURI));
            nameValuePairs.add(new BasicNameValuePair("grant_type", "authorization_code"));
            return new UrlEncodedFormEntity(nameValuePairs, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    UrlEncodedFormEntity getRefreshTokenPostEntity(String pRefreshToken) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        try {
            nameValuePairs.add(new BasicNameValuePair("refresh_token", pRefreshToken));
            nameValuePairs.add(new BasicNameValuePair("client_id", this.mClientID));
            nameValuePairs.add(new BasicNameValuePair("client_secret", this.mClientSecret));
            nameValuePairs.add(new BasicNameValuePair("grant_type", "refresh_token"));
            return new UrlEncodedFormEntity(nameValuePairs, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

