/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.oweb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import net.omnis.oweb.OWEBSMTP;

public abstract class JSONFile {
    public String mErrorInfo;
    public int mErrorCode = 0;
    File mJSONFile;
    JSONObject mJSON;

    JSONFile(String pAuthorityDir, String pFileName) {
        File authorityDir = new File(OWEBSMTP.smOauth2Folder, pAuthorityDir);
        this.mJSONFile = new File(authorityDir, pFileName);
        this.mErrorCode = this.readJSONFile(this.mJSONFile);
    }

    int readJSONFile(File pFile) {
        InputStreamReader isr;
        FileInputStream fis;
        if (!pFile.exists()) {
            return 10703;
        }
        if (pFile.length() == 0L) {
            pFile.delete();
            return 10703;
        }
        try {
            fis = new FileInputStream(pFile);
        }
        catch (FileNotFoundException e) {
            this.mErrorInfo = e.toString();
            return 10703;
        }
        try {
            isr = new InputStreamReader((InputStream)fis, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.mErrorInfo = e.toString();
            return 10704;
        }
        try {
            this.mJSON = (JSONObject)JSONValue.parseWithException((Reader)isr);
        }
        catch (IOException e) {
            this.mErrorInfo = e.toString();
            return 10705;
        }
        catch (ParseException e) {
            this.mErrorInfo = e.toString();
            return 10706;
        }
        catch (Exception e) {
            this.mErrorInfo = e.toString();
            return 10716;
        }
        return 0;
    }
}

