/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.omnis.webcore.authentication.NTLMSchemeFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import webcore.JarFileCreator;
import webcore.NullConsole;
import webcore.PortNode;
import webcore.ServiceNode;
import webcore.ThreadConsole;
import webcore.WSDLContentHandler;
import webcore.axisrunner;
import webcore.build;
import webcore.cligen;
import webcore.iConsole;
import webcore.interfacereader;
import webcore.methodline;
import webcore.methodlist;
import webcore.omcligen;

public class codegen {
    public static iConsole mConsole = new NullConsole();
    public static boolean smGotSystemProperties = false;
    public static boolean smOpenConsole = false;
    public static boolean smThreadLogging = false;
    public static boolean smClassLoaderLogging = false;
    String mDeployFolder = null;
    String mBuildFolder = null;
    String mOmnisGenFolder = null;
    String mLastError = null;
    String mWSDL = null;
    String mLocator = null;
    String mBuildPath = null;
    ArrayList<String> mBuildPaths = null;
    ArrayList<ServiceNode> mservicelist;
    ArrayList<PortNode> mportlist = null;
    ArrayList<String> mServiceFolderList = null;
    ArrayList<String> mDeployList = null;
    int mserviceidx = 0;
    int mportidx = 0;
    String[] mErrorList = null;
    WSDLContentHandler mWSDLHandler = null;
    Vector mMethodList = null;

    public codegen() {
        this.setThreadConsole();
        mConsole.println("Web Core Loaded");
    }

    private synchronized void setThreadConsole() {
        if (!smGotSystemProperties) {
            smGotSystemProperties = true;
            mConsole = smThreadLogging || smClassLoaderLogging || smOpenConsole ? new ThreadConsole() : new NullConsole();
        }
    }

    private String getWSDL(String url, String userId, String pswd) {
        String lfilename;
        this.mLastError = null;
        String lsep = System.getProperty("file.separator");
        String lresult = lfilename = this.mBuildFolder + lsep + "service.wsdl";
        try {
            String wsdl = this.fetchWSDL(url, userId, pswd);
            PrintWriter loutput = new PrintWriter(new BufferedWriter(new FileWriter(lfilename)));
            loutput.println(wsdl);
            loutput.flush();
            loutput.close();
        }
        catch (Exception e) {
            this.mLastError = "getWSDL exception in cligen: Unable to download WSDL for url " + url;
            lresult = null;
            return lresult;
        }
        return lresult;
    }

    public byte[] getWSDLSource(String url, String userId, String pswd) {
        String wsdl = this.fetchWSDL(url, userId, pswd);
        try {
            return wsdl.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return wsdl.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String fetchWSDL(String url, String userId, String pswd) {
        if (url.startsWith("http")) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            if (userId.length() > 0) {
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(userId, pswd, "", ""));
                localContext.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
            }
            try {
                String line;
                ArrayList<String> authpref = new ArrayList<String>();
                authpref.add("NTLM");
                authpref.add("Digest");
                authpref.add("Basic");
                httpclient.getAuthSchemes().register("ntlm", (AuthSchemeFactory)new NTLMSchemeFactory());
                httpclient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
                httpclient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
                HttpGet httpget = new HttpGet(url);
                HttpResponse response = httpclient.execute((HttpUriRequest)httpget, (HttpContext)localContext);
                HttpEntity entity = response.getEntity();
                if (entity == null) return "";
                BufferedReader in = new BufferedReader(new InputStreamReader(entity.getContent()));
                StringBuilder wsdl = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    wsdl.append(line);
                }
                EntityUtils.consume((HttpEntity)entity);
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String string = wsdl.toString();
                return string;
            }
            catch (Throwable t) {
                this.mLastError = t.getMessage();
                return "";
            }
            finally {
                httpclient.getConnectionManager().shutdown();
            }
        }
        InputStreamReader inStream = null;
        BufferedReader buff = null;
        StringBuilder source = new StringBuilder();
        if (url.length() < 1) {
            this.mLastError = "url is empty= " + url;
            mConsole.println(this.mLastError);
            return source.toString();
        }
        try {
            String nextLine;
            buff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(url)), "UTF8"));
            while ((nextLine = buff.readLine()) != null) {
                source.append(nextLine);
            }
        }
        catch (IOException e1) {
            this.mLastError = e1.toString();
        }
        mConsole.println(source.length() + " byte(s) copied");
        mConsole.println(source.toString());
        try {
            if (buff != null) {
                buff.close();
            }
            if (inStream == null) return source.toString();
            inStream.close();
            return source.toString();
        }
        catch (IOException e1) {
            mConsole.println("Can't free streams: " + e1.toString());
        }
        return source.toString();
    }

    private String callAxis(String pDestFolder, String pWSDL, String pUsername, String pPassword, String pPackageName, String portName) {
        if (pUsername.length() > 0 && pPassword.length() > 0) {
            String lhttp = null;
            if (pWSDL.indexOf(":") != -1) {
                lhttp = pWSDL.substring(0, pWSDL.indexOf(":"));
            }
            if (lhttp != null && (lhttp.equalsIgnoreCase("http") || lhttp.equalsIgnoreCase("https"))) {
                pWSDL = this.getWSDL(pWSDL, pUsername, pPassword);
            }
        }
        if (pWSDL == null) {
            return pWSDL;
        }
        axisrunner laxis = new axisrunner(pDestFolder, pWSDL, portName);
        boolean lresult = laxis.callAxis(pPackageName);
        if (!lresult) {
            if (this.mLastError == null) {
                this.mLastError = laxis.getLastError();
            }
            pWSDL = null;
        }
        return pWSDL;
    }

    private void getBuildFolder(File pDir, ArrayList<String> pName) {
        try {
            if (!pDir.exists()) {
                return;
            }
            File[] files = pDir.listFiles();
            int size = files.length;
            boolean containsJavaFiles = false;
            for (int i = 0; i < size; ++i) {
                String lname = files[i].toString();
                if (files[i].isDirectory()) {
                    this.getBuildFolder(files[i], pName);
                    if (this.mLastError == null) continue;
                    return;
                }
                if (!lname.toLowerCase().endsWith(".java")) continue;
                containsJavaFiles = true;
            }
            if (containsJavaFiles) {
                pName.add(pDir.toString());
            }
        }
        catch (Exception e) {
            this.mLastError = "getBuildFolder exception in codegen: " + e;
        }
    }

    public ArrayList<String> getBuildFolder(String pStart) {
        ArrayList<String> lvname = new ArrayList<String>();
        File lfile = new File(pStart);
        if (lfile.exists()) {
            this.mLastError = null;
            this.getBuildFolder(lfile, lvname);
            if (this.mLastError != null) {
                return null;
            }
        }
        return lvname;
    }

    private void deleteFolder(File dir) {
        this.mLastError = null;
        try {
            if (!dir.exists()) {
                return;
            }
            File[] files = dir.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteFolder(files[i]);
                    continue;
                }
                files[i].delete();
            }
            dir.delete();
        }
        catch (Exception e) {
            this.mLastError = "deleteFolder exception in codegen: " + e;
        }
    }

    private void clearFolder(String pFolder, boolean pMakeDir) {
        this.mLastError = null;
        try {
            File lfile = new File(pFolder);
            if (lfile.exists()) {
                this.deleteFolder(lfile);
                File lf = new File(pFolder);
                if (pMakeDir) {
                    lf.mkdir();
                }
            }
        }
        catch (Exception e) {
            this.mLastError = "clearFolder exception in codegen: " + e;
        }
    }

    private boolean deployClient(String pSrcFolder, String pDestFolder, String pObjectName) {
        File[] filelist;
        boolean lresult = true;
        String lsep = System.getProperty("file.separator");
        this.mLastError = null;
        try {
            File lsrc = new File(pSrcFolder);
            if (!lsrc.exists()) {
                this.mLastError = "deployClient exception in codegen: " + pSrcFolder + " not found";
                return false;
            }
            filelist = lsrc.listFiles();
        }
        catch (Exception e) {
            this.mLastError = "deployClient exception in codegen: " + e;
            return false;
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (!filelist[i].isDirectory()) continue;
            String lRootName = filelist[i].toString();
            lRootName = lRootName.substring(lRootName.lastIndexOf(lsep) + 1, lRootName.length());
            String ldst = pDestFolder + lsep + lRootName;
            File lfile = new File(ldst);
            this.mDeployList.add(ldst);
            break;
        }
        JarFileCreator creator = new JarFileCreator();
        String jarFilePath = pSrcFolder + lsep + pObjectName + ".jar";
        File jarFile = new File(jarFilePath);
        creator.createJarArchive(jarFile, pSrcFolder);
        String destPath = pDestFolder + lsep + pObjectName + ".jar";
        File lfile = new File(destPath);
        if (lfile.exists()) {
            lfile.delete();
        }
        jarFile.renameTo(lfile);
        File lSourcefile = new File(pSrcFolder);
        this.deleteFolder(lSourcefile);
        lSourcefile.mkdir();
        return lresult;
    }

    public void setBuildFolder(String pBuild) {
        this.mBuildFolder = pBuild;
    }

    public void setOmnisGenFolder(String pBuild) {
        this.mOmnisGenFolder = pBuild;
    }

    public void setDeployFolder(String pDeploy) {
        this.mDeployFolder = pDeploy;
    }

    private String[] getErrorLogs(String pPath) {
        String[] lresult = null;
        File lfile = new File(pPath);
        if (!lfile.exists()) {
            return lresult;
        }
        if (!lfile.isDirectory()) {
            return lresult;
        }
        File[] lfilelist = lfile.listFiles(new ffilter("*.log"));
        if (lfilelist != null && lfilelist.length > 0) {
            lresult = new String[lfilelist.length];
            for (int i = 0; i < lfilelist.length; ++i) {
                lresult[i] = lfilelist[i].getAbsolutePath();
            }
        }
        return lresult;
    }

    private String[] clientError(String pString) {
        String[] lresult = null;
        if (pString == null) {
            return lresult;
        }
        lresult = new String[]{pString};
        return lresult;
    }

    private String getSourceFileNameForClientGeneration(String pBuildPath, String pWSDL, String pPortName, String pPortBinding) {
        String lsrcname;
        boolean lfound;
        block10: {
            mConsole.println("getSourceFileNameForClientGeneration In (" + pBuildPath + "," + pWSDL + "," + pPortName + "," + pPortBinding + ")");
            StringTokenizer st = new StringTokenizer(pPortName, ".", false);
            String t = "";
            while (st.hasMoreElements()) {
                t = t + st.nextElement();
            }
            pPortName = t;
            mConsole.println("pPortName: " + pPortName);
            lfound = false;
            String lsep = System.getProperty("file.separator");
            lsrcname = pBuildPath + lsep + pPortName + ".java";
            lsrcname = lsrcname.toLowerCase();
            mConsole.println("lsrcname: " + lsrcname);
            try {
                String lfilename;
                int i;
                File lfile = new File(pBuildPath);
                File[] lfilelist = lfile.listFiles(new ffilter("*.java"));
                for (i = 0; i < lfilelist.length; ++i) {
                    lfilename = lfilelist[i].getAbsolutePath();
                    if (lfilename.compareToIgnoreCase(lsrcname) != 0) continue;
                    mConsole.println("File Found");
                    lsrcname = lfilename;
                    lfound = true;
                    break;
                }
                if (lfound) break block10;
                mConsole.println("File NOT Found");
                String lporttype = this.mWSDLHandler.getPortType(pPortBinding);
                lporttype = lporttype.substring(lporttype.indexOf(":") + 1, lporttype.length());
                st = new StringTokenizer(lporttype, ".", false);
                t = "";
                while (st.hasMoreElements()) {
                    t = t + st.nextElement();
                }
                lporttype = t;
                mConsole.println("lporttype: " + lporttype);
                lsrcname = pBuildPath + lsep + lporttype + ".java";
                lsrcname = lsrcname.toLowerCase();
                lfilelist = lfile.listFiles(new ffilter("*.java"));
                for (i = 0; i < lfilelist.length; ++i) {
                    lfilename = lfilelist[i].getAbsolutePath();
                    if (lfilename.compareToIgnoreCase(lsrcname) != 0) continue;
                    lsrcname = lfilename + "," + lporttype;
                    lfound = true;
                    break;
                }
                if (!lfound) {
                    lsrcname = pBuildPath + lsep + lporttype + "PortType.java";
                    lsrcname = lsrcname.toLowerCase();
                    lfilelist = lfile.listFiles(new ffilter("*.java"));
                    for (i = 0; i < lfilelist.length; ++i) {
                        lfilename = lfilelist[i].getAbsolutePath();
                        if (lfilename.compareToIgnoreCase(lsrcname) != 0) continue;
                        lsrcname = lfilename + "," + lporttype;
                        lfound = true;
                        break;
                    }
                }
                if (lfound) break block10;
                lsrcname = pBuildPath + lsep + lporttype + "_PortType.java";
                lsrcname = lsrcname.toLowerCase();
                lfilelist = lfile.listFiles(new ffilter("*.java"));
                for (i = 0; i < lfilelist.length; ++i) {
                    lfilename = lfilelist[i].getAbsolutePath();
                    if (lfilename.compareToIgnoreCase(lsrcname) != 0) continue;
                    lsrcname = lfilename + "," + lporttype;
                    lfound = true;
                    break;
                }
            }
            catch (Exception e) {
                this.mLastError = "getSourceFileNameForClientGeneration exception in codegen: " + e;
                e.printStackTrace();
                mConsole.println("Exception: " + this.mLastError);
                lsrcname = null;
            }
        }
        if (!lfound) {
            lsrcname = null;
        }
        mConsole.println("getSourceFileNameForClientGeneration Out");
        return lsrcname;
    }

    private String getCurrentService() {
        String lresult = null;
        this.mportidx = 0;
        if (this.mservicelist == null) {
            return null;
        }
        if (this.mserviceidx >= this.mservicelist.size()) {
            return null;
        }
        ServiceNode lnode = this.mservicelist.get(this.mserviceidx);
        if (lnode != null) {
            lresult = lnode.getName();
            this.mportlist = lnode.getPorts();
        }
        return lresult;
    }

    private String getCurrentServicePort() {
        String lresult = null;
        if (this.mportlist == null) {
            return lresult;
        }
        if (this.mportidx >= this.mportlist.size()) {
            return lresult;
        }
        lresult = this.mportlist.get(this.mportidx).getName();
        if (lresult != null) {
            lresult = lresult.substring(0, lresult.indexOf(","));
        }
        return lresult;
    }

    private String getCurrentPortBinding() {
        String lresult = null;
        if (this.mportlist == null) {
            return lresult;
        }
        lresult = this.mportlist.get(this.mportidx).getName();
        if (lresult != null) {
            lresult = lresult.substring(lresult.indexOf(",") + 1, lresult.length());
        }
        return lresult;
    }

    private String getNextService() {
        ++this.mserviceidx;
        if (this.mserviceidx >= this.mservicelist.size()) {
            return null;
        }
        return this.getCurrentService();
    }

    private void resetServiceList() {
        this.mserviceidx = 0;
    }

    private String getNextPort() {
        ++this.mportidx;
        if (this.mportidx >= this.mportlist.size()) {
            return null;
        }
        return this.getCurrentServicePort();
    }

    private void resetPortList() {
        this.mportidx = 0;
    }

    private String getWSDLPortType(String pPortBinding) {
        interfacereader lreader = new interfacereader();
        this.mLastError = null;
        String lporttypekey = "binding name=\"" + pPortBinding + "\"";
        lreader.openSource(this.mWSDL);
        this.mLastError = lreader.getLastError();
        if (this.mLastError != null) {
            return null;
        }
        lreader.readUntilFound(lporttypekey);
        this.mLastError = lreader.getLastError();
        if (this.mLastError != null) {
            return null;
        }
        String lresult = lreader.getCurrentLine();
        if (lresult != null) {
            String ltype = "type=\"";
            lresult = lresult.substring(lresult.indexOf(ltype) + ltype.length(), lresult.lastIndexOf("\""));
            lresult = lresult.substring(lresult.indexOf(":") + 1, lresult.length());
        }
        return lresult;
    }

    private Vector getWSDLServiceData(String pWSDL) {
        mConsole.println("getWSDLServiceData In (" + pWSDL + ")");
        String lservice = null;
        boolean lfoundservice = true;
        boolean lfoundport = true;
        String lq = "\"";
        interfacereader lreader = new interfacereader();
        String lservicekey = "service name";
        String lportkey = "port name";
        this.mLastError = null;
        lreader.openSource(pWSDL);
        this.mLastError = lreader.getLastError();
        if (this.mLastError != null) {
            return null;
        }
        lreader.readUntilFound(lservicekey);
        this.mLastError = lreader.getLastError();
        if (this.mLastError != null) {
            this.mLastError = "getWSDLServiceData exception in cligen. WSDL has no services. ";
            lreader.closeSource();
            mConsole.println(this.mLastError);
            mConsole.println("getWSDLServiceData Out");
            return null;
        }
        Vector lservicelist = new Vector();
        while (lfoundservice) {
            int epos;
            mConsole.println("Found Service");
            Vector<Object> lservicenode = new Vector<Object>();
            String lline = lreader.getCurrentLine();
            mConsole.println("Line: " + lline);
            int spos = lline.indexOf(lq);
            if (spos > 0) {
                ++spos;
            }
            if ((epos = lline.lastIndexOf(lq)) > 0 && spos > 0) {
                lservice = lline.substring(spos, epos);
            } else {
                mConsole.println("Spos: " + spos + " & Epos: " + epos);
            }
            mConsole.println("Service: " + lservice);
            lservicenode.add(lservice);
            lfoundport = lreader.readUntilFound(lportkey);
            mConsole.println("lfoundport: " + lfoundport);
            lline = lreader.getCurrentLine();
            mConsole.println("Port Line: " + lline);
            Vector<String> lportnode = new Vector<String>();
            while (lfoundport) {
                mConsole.println("Found port");
                if (lline.indexOf(lportkey) != -1) {
                    String lbinding = lline.substring(lline.indexOf("binding=\"") + 1, lline.lastIndexOf(lq));
                    lbinding = lbinding.substring(lbinding.indexOf(":") + 1, lbinding.length());
                    String lportname = lline.substring(lline.indexOf(lq) + 1, lline.indexOf("binding"));
                    lportname = lportname.substring(0, lportname.indexOf(lq));
                    lportname = lportname + "," + lbinding;
                    lportnode.add(lportname);
                }
                if ((lline = lreader.readLine()) == null) {
                    lfoundport = false;
                }
                if (!lfoundport || lline.indexOf("/wsdl:service") == -1) continue;
                lfoundport = false;
            }
            if (lportnode.isEmpty()) {
                this.mLastError = "getWSDLServiceData exception in cligen. WSDL contains no ports for service " + lservice;
                lreader.closeSource();
                mConsole.println(this.mLastError);
                mConsole.println("getWSDLServiceData Out");
                return null;
            }
            lservicenode.add(lportnode);
            lservicelist.add(lservicenode);
            lfoundservice = lreader.readUntilFound(lservicekey);
        }
        lreader.closeSource();
        mConsole.println("getWSDLServiceData Out - Success");
        return lservicelist;
    }

    private String getWSDLPortName(String pWSDL) {
        String lresult = null;
        String lq = "\"";
        interfacereader lreader = new interfacereader();
        String lporttype = "portType name";
        if (lreader.openSource(pWSDL) && lreader.readUntilFound(lporttype)) {
            this.mLastError = lreader.getLastError();
            if (this.mLastError == null) {
                lresult = lreader.getCurrentLine();
                lresult = lresult.substring(lresult.indexOf(lq) + 1, lresult.lastIndexOf(lq));
            }
            lreader.closeSource();
        }
        return lresult;
    }

    private String getWSDLServiceName(String pWSDL) {
        String lresult = null;
        String lq = "\"";
        interfacereader lreader = new interfacereader();
        String lporttype = "service name";
        if (lreader.openSource(pWSDL) && lreader.readUntilFound(lporttype)) {
            this.mLastError = lreader.getLastError();
            if (this.mLastError == null) {
                lresult = lreader.getCurrentLine();
                lresult = lresult.substring(lresult.indexOf(lq) + 1, lresult.lastIndexOf(lq));
            }
            lreader.closeSource();
        }
        return lresult;
    }

    public String getLastError() {
        return this.mLastError;
    }

    public String getLastErrorText() {
        return this.mLastError;
    }

    public String[] getErrorList() {
        return this.mErrorList;
    }

    public String[] getDeployFolderList() {
        if (this.mDeployList == null) {
            return null;
        }
        if (this.mDeployList.isEmpty()) {
            return null;
        }
        String[] lresult = new String[this.mDeployList.size()];
        for (int i = 0; i < lresult.length; ++i) {
            lresult[i] = this.mDeployList.get(i);
        }
        return lresult;
    }

    public String[] getServiceFolderList() {
        if (this.mServiceFolderList == null) {
            return null;
        }
        if (this.mServiceFolderList.isEmpty()) {
            return null;
        }
        String[] lresult = new String[this.mServiceFolderList.size()];
        for (int i = 0; i < lresult.length; ++i) {
            lresult[i] = this.mServiceFolderList.get(i);
        }
        return lresult;
    }

    public String getFileNameFromPath(String pPath) {
        String lsep = System.getProperty("file.separator");
        return pPath.substring(pPath.lastIndexOf(lsep) + 1, pPath.length());
    }

    public String getServiceNamePath(String pPath) {
        String lsep = System.getProperty("file.separator");
        return pPath.substring(0, pPath.lastIndexOf(lsep) + 1);
    }

    public String getServiceNameFromPath(String pPath) {
        String lsep = System.getProperty("file.separator");
        String lname = pPath.substring(pPath.lastIndexOf(lsep) + 1, pPath.length());
        return lname.substring(0, lname.lastIndexOf("."));
    }

    public String getWSDLFileName() {
        return this.mWSDL;
    }

    public boolean generateAndCompileAxisCode(String pWSDL, String pUserName, String pPassword, String pStudioHome, String pJavaHome, String pPackageName, String portName) {
        String osSeparator = System.getProperty("file.separator");
        boolean needSepAfterStudioHome = false;
        if (pStudioHome.lastIndexOf(osSeparator) != pStudioHome.length() - 1) {
            needSepAfterStudioHome = true;
        }
        String buildFolder = pStudioHome + (needSepAfterStudioHome ? osSeparator : "") + "java" + osSeparator + "build";
        String axis2home = pStudioHome + (needSepAfterStudioHome ? osSeparator : "") + "java" + osSeparator + "axis";
        String done = this.callAxis(buildFolder, pWSDL, pUserName, pPassword, pPackageName, portName);
        if (done != null) {
            build.callAnt(axis2home, pJavaHome, buildFolder);
            return true;
        }
        return false;
    }

    public boolean generateAndCompileAxisCode(String pWSDL, String pUsername, String pPassword, boolean pOmClient) {
        mConsole.println("generateAndCompileAxisCode In (" + pWSDL + ")");
        boolean lresult = true;
        this.mLastError = null;
        this.mErrorList = null;
        mConsole.println("Generate Java Code...");
        this.mWSDL = this.callAxis(this.mBuildFolder, pWSDL, pUsername, pPassword, "", "");
        if (this.mWSDL != null) {
            mConsole.println("Java Code Generated");
            this.mBuildPaths = this.getBuildFolder(this.mBuildFolder);
            long bpSize = this.mBuildPaths.size();
            int i = 0;
            while ((long)i < bpSize) {
                this.mBuildPath = this.mBuildPaths.get(i);
                mConsole.println("Build Path: " + this.mBuildPath);
                if (this.mBuildPath == null) {
                    this.mErrorList = this.clientError(this.mLastError);
                    return false;
                }
                if (pOmClient && !this.setAxisSoapActionProperty(this.mBuildPath, this.mWSDL)) {
                    return false;
                }
                if (!this.setSoapResponseCode(this.mBuildPath, this.mWSDL)) {
                    return false;
                }
                build lbuild = new build();
                mConsole.println("Compile Java Code...");
                if (!lbuild.buildFiles(this.mBuildPath, this.mBuildFolder)) {
                    mConsole.println("Java Code Failed to Compile");
                    lresult = false;
                    String lerrstr = lbuild.getLastError();
                    this.mErrorList = lerrstr == null ? this.getErrorLogs(this.mBuildPath) : this.clientError(lerrstr);
                }
                ++i;
            }
            mConsole.println("Java Code Compiled Successfully");
        } else {
            mConsole.println("Java Code Generation Failed");
            this.mErrorList = new String[2];
            lresult = false;
            this.mErrorList[0] = this.mLastError;
        }
        mConsole.println("generateAndCompileAxisCode Out");
        return lresult;
    }

    public boolean buildServices(String pWSDL, String pObjectName, boolean pOmClient) {
        mConsole.println("buildServices In (" + pWSDL + ")");
        Vector lmethodlist = null;
        this.mservicelist = null;
        this.mportlist = null;
        this.mserviceidx = 0;
        this.mportidx = 0;
        this.mServiceFolderList = new ArrayList();
        this.mDeployList = new ArrayList();
        this.mWSDLHandler = new WSDLContentHandler();
        int serviceListSize = 0;
        if (this.mWSDLHandler.parseWSDL(pWSDL)) {
            this.mservicelist = this.mWSDLHandler.getServiceList();
            if (this.mservicelist != null) {
                serviceListSize = this.mservicelist.size();
            }
        }
        mConsole.println("Service List Size: " + serviceListSize);
        for (int i = 0; i < serviceListSize; ++i) {
            ServiceNode serviceNode = this.mservicelist.get(i);
            ArrayList<PortNode> ports = serviceNode.getPorts();
            mConsole.println("Service: " + serviceNode.getName());
            mConsole.println("Port Node Size: " + ports.size());
            for (int k = 0; k < ports.size(); ++k) {
                PortNode portNode = ports.get(k);
                String portname = portNode.getName();
                mConsole.println("  Port: " + portname);
            }
        }
        if (serviceListSize == 0) {
            mConsole.println("ERROR: No Services found in this WSDL.");
            this.mLastError = "No Services found in this WSDL.";
            this.mErrorList = this.clientError(this.mLastError);
            mConsole.println("buildServices Out");
            return false;
        }
        if (this.mservicelist != null) {
            boolean lextendname = true;
            mConsole.println("Get Current Service");
            String lservice = this.getCurrentService();
            while (lservice != null) {
                mConsole.println("Service: " + lservice);
                String lport = this.getCurrentServicePort();
                while (lport != null) {
                    mConsole.println("Port: " + lport);
                    if (this.mportlist.size() == 1) {
                        lextendname = false;
                    }
                    mConsole.println("Get Binding");
                    String lbinding = this.getCurrentPortBinding();
                    String lPortTypeName = this.mWSDLHandler.getPortType(lbinding);
                    mConsole.println("Binding: " + lbinding);
                    mConsole.println("lPortTypeName: " + lPortTypeName);
                    mConsole.println("generateAndCompileJavaStub");
                    lmethodlist = this.generateAndCompileJavaStub(lservice, lport, lbinding, lextendname, pOmClient, lPortTypeName);
                    if (lmethodlist == null) {
                        mConsole.println("ERROR: No Methodlist");
                        mConsole.println("buildServices Out");
                        return false;
                    }
                    mConsole.println("generateOmnisStub");
                    if (!this.generateOmnisStub(lservice, lport, lmethodlist, lextendname, pObjectName, pOmClient)) {
                        mConsole.println("ERROR: generateOmnisStub failed");
                        mConsole.println("buildServices Out");
                        return false;
                    }
                    lport = this.getNextPort();
                }
                lservice = this.getNextService();
            }
        } else {
            mConsole.println("ERROR: getWSDLServiceData failed");
            mConsole.println("buildServices Out");
            return false;
        }
        mConsole.println("deployJavaCode");
        if (!this.deployJavaCode(pObjectName)) {
            mConsole.println("ERROR: deployJavaCode failed");
            mConsole.println("buildServices Out");
            return false;
        }
        mConsole.println("buildServices Out Success");
        return true;
    }

    public boolean clearOmnisFolder() {
        boolean lresult = true;
        this.mLastError = null;
        this.mErrorList = null;
        if (this.mOmnisGenFolder == null) {
            return false;
        }
        this.clearFolder(this.mOmnisGenFolder, true);
        if (this.mLastError != null) {
            this.mErrorList = this.clientError(this.mLastError);
            lresult = false;
        }
        return lresult;
    }

    public boolean clearBuildFolder() {
        boolean lresult = true;
        this.mLastError = null;
        this.mErrorList = null;
        if (this.mOmnisGenFolder == null) {
            return false;
        }
        this.clearFolder(this.mBuildFolder, true);
        if (this.mLastError != null) {
            this.mErrorList = this.clientError(this.mLastError);
            lresult = false;
        }
        return lresult;
    }

    private Vector generateAndCompileJavaStub(String pServiceName, String pPortName, String pPortBinding, boolean pExtendName, boolean pOmClient, String pPortTypeName) {
        String lsrcname;
        mConsole.println("generateAndCompileJavaStub In (" + pServiceName + ", " + pPortName + ", " + pPortBinding + ", " + pExtendName + ")");
        StringTokenizer st = new StringTokenizer(pServiceName, ".", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = t + st.nextElement();
        }
        pServiceName = t;
        mConsole.println("pServiceName: " + pServiceName);
        String lsep = System.getProperty("file.separator");
        String lporttype = pPortName;
        this.mLastError = null;
        this.mErrorList = null;
        String lfilename = pServiceName + ".java";
        this.mBuildPath = this.getBuildPathForFile(lfilename);
        this.mLocator = "Locator";
        if (this.mBuildPath == null) {
            lfilename = pServiceName + "_Service.java";
            this.mBuildPath = this.getBuildPathForFile(lfilename);
            this.mLocator = "_ServiceLocator";
        }
        if ((lsrcname = this.getSourceFileNameForClientGeneration(this.mBuildPath, this.mWSDL, pPortTypeName, pPortBinding)) == null) {
            mConsole.println("Failed to get source name: " + this.mLastError);
            mConsole.println("generateAndCompileJavaStub Out");
            this.mErrorList = this.clientError(this.mLastError);
            return null;
        }
        if (lsrcname.indexOf(",") != -1) {
            lporttype = lsrcname.substring(lsrcname.indexOf(",") + 1, lsrcname.length());
            lsrcname = lsrcname.substring(0, lsrcname.indexOf(","));
        }
        mConsole.println("Source Name :" + lsrcname);
        mConsole.println("Port Type :" + lporttype);
        String lstubname = pExtendName ? this.mBuildPath + lsep + pServiceName + "_" + pPortName + "OmClient.java" : this.mBuildPath + lsep + pServiceName + "OmClient.java";
        mConsole.println("Stub Name :" + lstubname);
        mConsole.println("lsrcname = " + lsrcname);
        mConsole.println("lstubname = " + lstubname);
        mConsole.println("Getting list of method lines..");
        mConsole.println("Getting method lines");
        methodlist lmlist = new methodlist();
        ArrayList<methodline> llist = lmlist.getClients(lsrcname);
        if (llist == null) {
            mConsole.println("Failed to get method list: " + lmlist.getLastError());
            mConsole.println("generateAndCompileJavaStub Out");
            this.mErrorList = this.clientError(lmlist.getLastError());
            return null;
        }
        mConsole.println("Generating source to " + this.mBuildFolder);
        mConsole.println("Generating source to " + this.mBuildFolder);
        cligen srcgen = new cligen(llist, this.mBuildFolder, pPortName, lporttype, pServiceName, pPortBinding, pOmClient, this);
        mConsole.println("Generating Java Stub");
        if (!srcgen.generateJava(lstubname)) {
            mConsole.println("Failed to generateJava: " + srcgen.getLastError());
            mConsole.println("generateAndCompileJavaStub Out");
            this.mErrorList = this.clientError(srcgen.getLastError());
            return null;
        }
        mConsole.println("Generation complete..");
        mConsole.println("Generation complete..");
        build lbuild = new build();
        mConsole.println("Compile Java Stub.");
        if (!lbuild.buildJava(this.mBuildPath, this.mBuildFolder, lstubname)) {
            String lerrstr = lbuild.getLastError();
            if (lerrstr == null) {
                String llogname = lstubname.substring(0, lstubname.indexOf("."));
                llogname = llogname + ".log";
                mConsole.println("Failed to compile java stub: see " + llogname);
                this.mErrorList = this.clientError(llogname);
            } else {
                mConsole.println("Failed to compile java stub: " + lerrstr);
                this.mErrorList = this.clientError(lerrstr);
            }
            mConsole.println("generateAndCompileJavaStub Out");
            return null;
        }
        mConsole.println("generateAndCompileJavaStub Out - Success");
        return new Vector<methodline>(llist);
    }

    private boolean deployJavaCode(String pObjectName) {
        String lsep = System.getProperty("file.separator");
        String lservicefolder = this.mBuildPath.substring(this.mBuildPath.indexOf(this.mBuildFolder) + this.mBuildFolder.length() + 1, this.mBuildPath.length());
        this.mLastError = null;
        this.mErrorList = null;
        lservicefolder = lservicefolder.indexOf(lsep) != -1 ? this.mDeployFolder + lsep + lservicefolder.substring(0, lservicefolder.indexOf(lsep)) : this.mDeployFolder + lsep + lservicefolder;
        this.clearFolder(lservicefolder, false);
        if (this.mLastError != null) {
            this.mErrorList = this.clientError(this.mLastError);
            return false;
        }
        if (!this.deployClient(this.mBuildFolder, this.mDeployFolder, pObjectName)) {
            this.mErrorList = this.clientError(this.mLastError);
            return false;
        }
        return true;
    }

    private boolean generateOmnisStub(String pServiceName, String pPortName, Vector pMethodList, boolean pExtendName, String pObjectName, boolean pOmClient) {
        String lsep = System.getProperty("file.separator");
        this.mLastError = null;
        this.mErrorList = null;
        String lgenfolder = pExtendName ? this.mOmnisGenFolder + lsep + pServiceName + "_" + pPortName : this.mOmnisGenFolder + lsep + pServiceName;
        try {
            File lfile = new File(lgenfolder);
            lfile.mkdir();
        }
        catch (Exception e) {
            this.mLastError = "generateOmnisStub exception in cligen: Could not create folder " + lgenfolder;
            this.mErrorList = this.clientError(this.mLastError);
            return false;
        }
        String lstubname = pExtendName ? this.mBuildPath + lsep + pServiceName + "_" + pPortName + "OmClient.java" : this.mBuildPath + lsep + pServiceName + "OmClient.java";
        String lservicepath = lstubname.substring(lstubname.indexOf(this.mBuildFolder) + this.mBuildFolder.length() + 1, lstubname.lastIndexOf("."));
        omcligen omsrcgen = new omcligen(pMethodList, lgenfolder, pPortName, pServiceName, lservicepath, pObjectName, pOmClient);
        if (!omsrcgen.generateOmnis()) {
            this.mErrorList = this.clientError(omsrcgen.getLastError());
            return false;
        }
        this.mServiceFolderList.add(lgenfolder);
        return true;
    }

    public Vector testVector(char[] p1, byte[] p2) {
        Vector<String> lresult = new Vector<String>();
        String lstring = new String("Test");
        lresult.addElement(lstring);
        return lresult;
    }

    private boolean setAxisSoapActionProperty(String pBuildPath, String pWSDL) {
        boolean status = true;
        this.mWSDLHandler = new WSDLContentHandler();
        if (this.mWSDLHandler.parseWSDL(pWSDL)) {
            ArrayList<String> portBindings = this.mWSDLHandler.getPortBindings();
            for (int i = 0; i < portBindings.size(); ++i) {
                String lsep = System.getProperty("file.separator");
                String stubFile = pBuildPath + lsep + portBindings.get(i) + "Stub.java";
                String tempFile = pBuildPath + lsep + "temp.java";
                File f = new File(tempFile);
                try {
                    FileReader fr = new FileReader(stubFile);
                    BufferedReader br = new BufferedReader(fr);
                    f.createNewFile();
                    FileWriter fw = new FileWriter(f);
                    BufferedWriter bw = new BufferedWriter(fw);
                    PrintWriter pw = new PrintWriter(bw);
                    StringBuilder stubCode = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        String nextline;
                        if (line.indexOf("_call.setSOAPActionURI") > 0) {
                            line = "_call.setSOAPActionURI(mSoapActionURI);";
                        }
                        if ((nextline = br.readLine()) != null) {
                            pw.println(line);
                        }
                        line = nextline;
                    }
                    stubCode.append("  private String mSoapActionURI = null;   public void setSoapActionURI(String pSoapActionURI){   mSoapActionURI = pSoapActionURI;  }");
                    pw.println(stubCode.toString());
                    pw.println("  }");
                    pw.flush();
                    fr.close();
                    fw.close();
                    File lOldfile = new File(stubFile);
                    lOldfile.delete();
                    f.renameTo(new File(stubFile));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            status = false;
        }
        return status;
    }

    private boolean setSoapResponseCode(String pBuildPath, String pWSDL) {
        boolean status = true;
        this.mWSDLHandler = new WSDLContentHandler();
        if (this.mWSDLHandler.parseWSDL(pWSDL)) {
            ArrayList<String> portBindings = this.mWSDLHandler.getPortBindings();
            for (int i = 0; i < portBindings.size(); ++i) {
                String lsep = System.getProperty("file.separator");
                String stubFile = pBuildPath + lsep + portBindings.get(i) + "Stub.java";
                String tempFile = pBuildPath + lsep + "temp.java";
                File f = new File(tempFile);
                try {
                    FileReader fr;
                    boolean usingBindingStub = false;
                    try {
                        fr = new FileReader(stubFile);
                    }
                    catch (FileNotFoundException e) {
                        stubFile = pBuildPath + lsep + portBindings.get(i) + "_BindingStub.java";
                        fr = new FileReader(stubFile);
                        usingBindingStub = true;
                    }
                    BufferedReader br = new BufferedReader(fr);
                    f.createNewFile();
                    FileWriter fw = new FileWriter(f);
                    BufferedWriter bw = new BufferedWriter(fw);
                    PrintWriter pw = new PrintWriter(bw);
                    StringBuilder stubCode = new StringBuilder();
                    String line = br.readLine();
                    String classHeader = "class " + portBindings.get(i) + (usingBindingStub ? "_BindingStub" : "Stub");
                    mConsole.println("ClassHeader: " + classHeader);
                    while (line != null) {
                        String nextline;
                        boolean printed = false;
                        if (line.toLowerCase().indexOf(classHeader.toLowerCase()) > 0) {
                            String include = "import org.apache.axis.*;";
                            pw.println(include);
                            pw.println(line);
                            printed = true;
                        }
                        if (line.indexOf("_call.invoke") > 0) {
                            pw.println(line);
                            line = "Message response = _call.getResponseMessage();";
                            pw.println(line);
                            line = "mSoapResponse = response.getSOAPPartAsString();";
                            pw.println(line);
                            printed = true;
                        }
                        if ((nextline = br.readLine()) != null && !printed) {
                            pw.println(line);
                        }
                        line = nextline;
                    }
                    stubCode.append("  private String mSoapResponse = null;   public String getSoapResponse(){   \treturn mSoapResponse;  }");
                    pw.println(stubCode.toString());
                    pw.println("  }");
                    pw.flush();
                    fr.close();
                    fw.close();
                    File lOldfile = new File(stubFile);
                    lOldfile.delete();
                    f.renameTo(new File(stubFile));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            status = false;
        }
        return status;
    }

    public Object[] getDocumentation() {
        if (smThreadLogging) {
            mConsole.println("In Codegen getDocumentation()");
        }
        return this.mWSDLHandler.getDocumentation();
    }

    public String getBuildPathForFile(String pFileName) {
        long bpSize = this.mBuildPaths.size();
        int i = 0;
        while ((long)i < bpSize) {
            String lBuildPath = this.mBuildPaths.get(i);
            File lDir = new File(lBuildPath);
            File[] files = lDir.listFiles();
            int size = files.length;
            for (int j = 0; j < size; ++j) {
                String lname = files[j].getName();
                if (files[i].isDirectory() || !lname.equalsIgnoreCase(pFileName)) continue;
                return lBuildPath;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<String> getPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        char lsepstr = System.getProperty("file.separator").charAt(0);
        long bpSize = this.mBuildPaths.size();
        int i = 0;
        while ((long)i < bpSize) {
            String lBuildPath = this.mBuildPaths.get(i);
            String lpackage = lBuildPath.substring(lBuildPath.indexOf(this.mBuildFolder) + this.mBuildFolder.length() + 1);
            lpackage = lpackage.replace(lsepstr, '.');
            packages.add(lpackage);
            ++i;
        }
        return packages;
    }

    public String getStubClassName(String pJarFile) {
        String stubName = "";
        try {
            File jarFile = new File(pJarFile);
            JarFile jf = new JarFile(jarFile);
            Enumeration<JarEntry> jarFileEntries = jf.entries();
            while (jarFileEntries.hasMoreElements()) {
                String className = ((Object)jarFileEntries.nextElement()).toString();
                if (!className.endsWith("Stub.class") || className.indexOf("$") != -1) continue;
                stubName = className.replace('/', '\\');
                stubName = stubName.substring(0, stubName.lastIndexOf(".class"));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stubName;
    }

    static class ffilter
    implements FilenameFilter {
        String mFilter;

        ffilter(String pString) {
            String all = "*.*";
            if (all.compareTo(pString) == 0) {
                this.mFilter = pString;
            } else {
                this.mFilter = pString.substring(1, pString.length());
                this.mFilter = this.mFilter.toLowerCase();
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            String all = "*.*";
            boolean allowfile = false;
            if (all.compareTo(this.mFilter) == 0) {
                return true;
            }
            String lname = name.toLowerCase();
            if (lname.indexOf(this.mFilter) > 0) {
                allowfile = true;
            }
            return allowfile;
        }
    }
}

