/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import webcore.FileClassLoader;
import webcore.codegen;
import webcore.iConsole;
import webcore.methodline;

public class cligen {
    ArrayList<methodline> mMethodList = null;
    String mBuildFolder = null;
    PrintWriter mGenerate = null;
    String mLastError = null;
    String mPortName = null;
    String mServiceName = null;
    String mPortType = null;
    String mBindingName = null;
    boolean mOmClient = false;
    codegen mCodeGen = null;
    iConsole mConsole;

    public cligen(ArrayList<methodline> pMethodList, String pBuildDir, String pPortName, String pPortType, String pServiceName, String pBindingName, boolean pOmClient, codegen pCodeGen) {
        this.mMethodList = pMethodList;
        this.mBuildFolder = pBuildDir;
        this.mPortName = pPortName;
        this.mPortType = pPortType;
        this.mServiceName = pServiceName;
        this.mBindingName = pBindingName.substring(0, 1).toUpperCase() + pBindingName.substring(1);
        this.mOmClient = pOmClient;
        this.mCodeGen = pCodeGen;
        this.mConsole = codegen.mConsole;
    }

    private String getMethodName(String pType, String pJType, String pPath) {
        Method[] lmethods;
        Class lclass;
        String lclassname;
        FileClassLoader loader;
        String lresult = null;
        String lsepstr = System.getProperty("file.separator");
        char[] lsep = lsepstr.toCharArray();
        String lbuildpath = this.mCodeGen.getBuildPathForFile(pJType + ".class");
        String lfilename = lbuildpath + lsepstr + pJType + ".class";
        try {
            loader = new FileClassLoader(lfilename, null);
            lclassname = lfilename.substring(lfilename.indexOf(this.mBuildFolder) + this.mBuildFolder.length() + 1, lfilename.lastIndexOf("."));
            lclassname = lclassname.replace(lsep[0], '.');
            this.mConsole.println("mBuildFolder = " + this.mBuildFolder);
            this.mConsole.println("lfilename = " + lfilename);
            this.mConsole.println("lclassname = " + lclassname);
        }
        catch (Exception ex) {
            this.mLastError = "cligen exception in getMethodName: could not create FileClassLoader for " + lfilename;
            return lresult;
        }
        try {
            lclass = loader.loadClass(lclassname);
        }
        catch (Exception ex) {
            this.mLastError = "cligen exception in getMethodName: could not load class " + lclassname;
            return lresult;
        }
        try {
            lmethods = lclass.getDeclaredMethods();
        }
        catch (Exception ex) {
            this.mLastError = "cligen exception in getMethodName: could not get declared methods for " + lclassname;
            return lresult;
        }
        try {
            if (lmethods != null && lmethods.length > 0) {
                for (Method lmethod : lmethods) {
                    String lmethname = lmethod.toString();
                    String ltmp = lmethname.substring(0, lmethname.lastIndexOf("("));
                    int idx = ltmp.lastIndexOf(".");
                    lmethname = lmethname.substring(idx + 1, lmethname.length());
                    if (pType.equals("SET")) {
                        if (lmethname.indexOf("set") != 0 || lmethname.indexOf("[]") <= lmethname.indexOf("(")) continue;
                        lresult = lmethname;
                        break;
                    }
                    if (pType.equals("ARR")) {
                        if (lmethname.indexOf("set") != 0 || lmethname.indexOf("[]") <= lmethname.indexOf("(")) continue;
                        lresult = lmethname.substring(lmethname.indexOf("(") + 1, lmethname.indexOf("[]"));
                        this.mConsole.println("lresult = " + lresult);
                        break;
                    }
                    Class<?> lrettype = lmethod.getReturnType();
                    if (lrettype == null || lmethname.indexOf("get") != 0 || !lrettype.isArray()) continue;
                    lresult = lmethname;
                    break;
                }
            }
            if (lresult != null && !pType.equals("ARR")) {
                lresult = lresult.substring(0, lresult.indexOf("("));
                this.mConsole.println("lresult = " + lresult);
                this.mConsole.println("lresult = " + lresult);
            }
        }
        catch (Exception ex) {
            this.mLastError = "cligen exception in getMethodName: " + ex;
        }
        return lresult;
    }

    private void openGenerator(String pFileName, String pClassName) {
        if (this.mGenerate != null) {
            return;
        }
        this.mLastError = null;
        try {
            this.mGenerate = new PrintWriter(new BufferedWriter(new FileWriter(pFileName)));
            this.mGenerate.println("/*****************************************");
            this.mGenerate.println(" " + pClassName);
            this.mGenerate.println();
            this.mGenerate.println(" Source Generated by cligen");
            this.mGenerate.println();
            this.mGenerate.println("******************************************/");
            this.mGenerate.println();
            String lsepstr = System.getProperty("file.separator");
            char[] lsep = lsepstr.toCharArray();
            String lpackage = pFileName.substring(pFileName.indexOf(this.mBuildFolder) + this.mBuildFolder.length() + 1, pFileName.lastIndexOf(lsepstr) + 1);
            lpackage = lpackage.replace(lsep[0], '.');
            lpackage = lpackage.substring(0, lpackage.lastIndexOf("."));
            this.mGenerate.println("package " + lpackage + ";");
            ArrayList<String> limports = this.mCodeGen.getPackages();
            long impsize = limports.size();
            int i = 0;
            while ((long)i < impsize) {
                String limppackage = limports.get(i);
                this.mGenerate.println("import " + limppackage + ".*;");
                ++i;
            }
            this.mGenerate.println("import javax.xml.rpc.ServiceException;");
            this.mGenerate.println("import java.util.*;");
            this.mGenerate.println("import java.math.*;");
            this.mGenerate.println("import org.apache.axis.types.*;");
            this.mGenerate.println("import org.apache.axis.holders.*;");
            this.mGenerate.println("import java.net.*;");
            this.mGenerate.println("import javax.xml.rpc.holders.*;");
            this.mGenerate.println();
            this.mGenerate.println("public class " + pClassName);
            this.mGenerate.println("{");
            this.mGenerate.println("  String mLastError;");
            this.mGenerate.println("  String mUsername;");
            this.mGenerate.println("  String mPassword;");
            this.mGenerate.println("  URL mEndPoint;");
            this.mGenerate.println("  String mSoapResponse;");
            if (this.mOmClient) {
                this.mGenerate.println("  String mSoapActionURI;");
            }
            this.mGenerate.println();
            if (this.mOmClient) {
                this.mGenerate.println("  public " + pClassName + "(String pEndPoint, String pUsername, String pPassword, String pSoapActionURI, int pProxyPort)");
            } else {
                this.mGenerate.println("  public " + pClassName + "(String pEndPoint, String pUsername, String pPassword, int pProxyPort)");
            }
            this.mGenerate.println("  {");
            this.mGenerate.println("    mLastError = null;");
            this.mGenerate.println();
            this.mGenerate.println("if(pProxyPort>0){");
            this.mGenerate.println("\tSystem.setProperty( \"http.proxySet\", \"true\" );");
            this.mGenerate.println("\tSystem.setProperty( \"http.proxyHost\", \"http-proxy\" );");
            this.mGenerate.println("\tSystem.setProperty( \"http.proxyPort\", Integer.toString(pProxyPort) );");
            this.mGenerate.println("} else {");
            this.mGenerate.println("\tSystem.setProperty( \"http.proxySet\", \"false\" );");
            this.mGenerate.println("}");
            this.mGenerate.println();
            this.mGenerate.println("    try{");
            this.mGenerate.println("      if(pEndPoint.length()>0)");
            this.mGenerate.println("        mEndPoint = new URL(pEndPoint);");
            this.mGenerate.println("      else");
            this.mGenerate.println("       mEndPoint = null;");
            this.mGenerate.println("    } catch (MalformedURLException me){");
            this.mGenerate.println("      mLastError = new String(\"Exception: \"+me);");
            this.mGenerate.println("    }");
            this.mGenerate.println();
            this.mGenerate.println("    mUsername = pUsername;");
            this.mGenerate.println("    mPassword = pPassword;");
            this.mGenerate.println("    mSoapResponse = null;");
            if (this.mOmClient) {
                this.mGenerate.println("    mSoapActionURI = pSoapActionURI;");
            }
            this.mGenerate.println("  }");
            this.mGenerate.println();
            this.mGenerate.flush();
        }
        catch (Exception e) {
            this.mLastError = "cligen exception in openGenerator: " + e;
        }
    }

    private void closeGenerator() {
        if (this.mGenerate == null) {
            return;
        }
        this.mGenerate.println("  public String getLastException()");
        this.mGenerate.println("  {");
        this.mGenerate.println("    return mLastError;");
        this.mGenerate.println("  }");
        this.mGenerate.println("  public String getSoapResponse()");
        this.mGenerate.println("  {");
        this.mGenerate.println("    return mSoapResponse;");
        this.mGenerate.println("  }");
        this.mGenerate.println("}");
        this.mGenerate.flush();
        this.mGenerate.close();
    }

    private void openMethod(String pDefinition, String pName, String pThrows, Vector pRetType, Vector pParms) {
        String lparms;
        this.mConsole.println("openMethod In (" + pDefinition + ", " + pName + ", " + pThrows + ", " + pRetType + ", " + pParms + ")");
        String[] parmName = null;
        String[] parmType = null;
        String[] newType = null;
        String lindent = "  ";
        if (pParms != null) {
            parmName = (String[])pParms.get(0);
            parmType = (String[])pParms.get(1);
            newType = (String[])pParms.get(2);
        }
        String lrettype = null;
        if (pRetType != null && (lrettype = (String)pRetType.get(1)) == null) {
            lrettype = (String)pRetType.get(0);
        }
        String lline = pDefinition + " " + lrettype + " " + pName;
        this.mConsole.println("Line : " + lline);
        this.mConsole.println("Create a parameter string");
        if (pParms != null) {
            lparms = "(";
            for (int i = 0; i < parmName.length; ++i) {
                String lnewtype = newType[i] != null ? newType[i] : parmType[i];
                lparms = lparms + lnewtype + " " + parmName[i] + ", ";
            }
            lparms = lparms.substring(0, lparms.lastIndexOf(","));
            lparms = lparms + ")";
        } else {
            lparms = "()";
        }
        lline = lindent + lline + lparms + " " + pThrows + ", ServiceException";
        this.mConsole.println("Line :" + lline);
        this.mGenerate.println(lline);
        lline = lindent + "{";
        this.mGenerate.println(lline);
        this.mGenerate.flush();
        this.mConsole.println("openMethod Out");
    }

    private String generateCallParameters(Vector pParms, Vector pGetList, String pPath) {
        String lparms = null;
        this.mLastError = null;
        try {
            if (pParms == null) {
                lparms = "();";
                return lparms;
            }
            lparms = "(";
            String[] parmName = (String[])pParms.get(0);
            String[] parmType = (String[])pParms.get(1);
            String[] newType = (String[])pParms.get(2);
            String pname = "OmParm";
            String lindent = "      ";
            int pcount = 1;
            for (int i = 0; i < parmName.length; ++i) {
                if (newType[i] != null) {
                    this.mGenerate.println(lindent + parmType[i] + " " + pname + pcount + " = (" + parmType[i] + ")" + parmName[i] + ";");
                    lparms = lparms + pname + pcount + ", ";
                    ++pcount;
                    continue;
                }
                lparms = lparms + parmName[i] + ", ";
            }
            this.mGenerate.flush();
            lparms = lparms.substring(0, lparms.lastIndexOf(","));
            lparms = lparms + ");";
        }
        catch (Exception e) {
            this.mLastError = "cligen exception in generateCallParameters: " + e;
        }
        return lparms;
    }

    private void handleReturnType(Vector pRetType, String pPath) {
        this.mLastError = null;
        try {
            String lrettype = (String)pRetType.get(0);
            String lnewtype = (String)pRetType.get(1);
            String lindent = "    ";
            if (lnewtype != null) {
                if (lrettype.indexOf("ArrayOf") != -1) {
                    String lmethodname = this.getMethodName("GET", lrettype, pPath);
                    this.mGenerate.println(lindent + "if (lresult != null)");
                    this.mGenerate.println(lindent + "  return lresult." + lmethodname + "();");
                    this.mGenerate.println(lindent + "return null;");
                } else {
                    this.mGenerate.println(lindent + "return (" + lnewtype + ")lresult;");
                }
            } else if (!lrettype.equalsIgnoreCase("void")) {
                this.mGenerate.println(lindent + "return lresult;");
            }
        }
        catch (Exception e) {
            this.mLastError = "cligen exception in handleReturnType: " + e;
        }
    }

    public boolean generateJava(String pFileName) {
        String lomclassname;
        String lpath;
        this.mConsole.println("generateJava In (" + pFileName + ")");
        String lrtype = null;
        String lindent = "    ";
        String lind1 = "  ";
        String lsep = System.getProperty("file.separator");
        this.mLastError = null;
        try {
            this.mConsole.println("Getting path and classname");
            lpath = pFileName.substring(0, pFileName.lastIndexOf(lsep));
            lomclassname = pFileName.substring(pFileName.lastIndexOf(lsep) + 1, pFileName.lastIndexOf("."));
            this.mConsole.println("Path: " + lpath);
            this.mConsole.println("Classname: " + lomclassname);
        }
        catch (Exception e) {
            this.mConsole.println("ERROR: " + e);
            this.mConsole.println("generateJava Out");
            this.mLastError = "cligen exception in generateJava: " + e;
            return false;
        }
        this.mConsole.println("Opening Generator");
        this.openGenerator(pFileName, lomclassname);
        if (this.mLastError != null) {
            this.mConsole.println("ERROR: " + this.mLastError);
            this.mConsole.println("generateJava Out");
            return false;
        }
        this.mConsole.println("Methodlist count: " + this.mMethodList.size());
        for (int i = 0; i < this.mMethodList.size(); ++i) {
            this.mConsole.println("Getting Methodline");
            methodline lmethod = this.mMethodList.get(i);
            this.mConsole.println("Getting Data");
            String lDefinition = lmethod.getDefinition();
            Vector lRetType = lmethod.getRetType();
            String lName = lmethod.getName();
            Vector lParms = lmethod.getParms();
            String lThrows = lmethod.getThrows();
            this.mConsole.println("Generate Method declaration");
            this.openMethod(lDefinition, lName, lThrows, lRetType, lParms);
            this.mGenerate.println(lindent + "mLastError = null; //Clear the error");
            this.mGenerate.println(lindent + "mSoapResponse = null; //Clear the last soap response");
            this.mConsole.println("Generate Return Parameter");
            if (lRetType != null && !(lrtype = (String)lRetType.get(0)).equalsIgnoreCase("void")) {
                String initval = this.getInitVal(lrtype);
                this.mGenerate.println(lindent + lrtype + " lresult = " + initval + ";");
            }
            this.mConsole.println("Generate function body");
            this.mGenerate.println();
            this.mGenerate.println(lindent + "try");
            this.mGenerate.println(lindent + "{");
            this.mGenerate.println(lindent + lind1 + "//Axis Soap Binding..");
            String serviceObjName = this.mServiceName.substring(0, 1).toUpperCase() + this.mServiceName.substring(1) + this.mCodeGen.mLocator;
            this.mGenerate.println(lindent + lind1 + serviceObjName + " t" + serviceObjName + " = new " + serviceObjName + "();");
            String bindingObj = this.mCodeGen.mLocator.equals("_ServiceLocator") ? this.mBindingName + "_BindingStub" : this.mBindingName + "Stub";
            String bindingObjVar = "t" + this.mPortName;
            this.mGenerate.println();
            this.mGenerate.println(lindent + lind1 + bindingObj + " " + bindingObjVar + ";");
            this.mGenerate.println(lindent + lind1 + "if(mEndPoint == null)");
            this.mGenerate.println(lindent + lind1 + lind1 + bindingObjVar + " = (" + bindingObj + ") t" + serviceObjName + ".get" + this.mPortName + "();");
            this.mGenerate.println(lindent + lind1 + "else");
            this.mGenerate.println(lindent + lind1 + lind1 + bindingObjVar + " = (" + bindingObj + ") t" + serviceObjName + ".get" + this.mPortName + "(mEndPoint);");
            this.mGenerate.println();
            this.mGenerate.println(lindent + lind1 + "if(mUsername.length()>0) t" + this.mPortName + ".setUsername(mUsername);");
            this.mGenerate.println(lindent + lind1 + "if(mPassword.length()>0) t" + this.mPortName + ".setPassword(mPassword);");
            this.mGenerate.println();
            this.mGenerate.println(lindent + lind1 + "//Call Web Service..");
            this.mConsole.println("Generate parameter string for method call");
            Vector llist = new Vector();
            String lparmstr = this.generateCallParameters(lParms, llist, lpath);
            if (this.mLastError != null) {
                this.mConsole.println("ERROR: " + this.mLastError);
                this.mConsole.println("generateJava Out");
                return false;
            }
            if (this.mOmClient) {
                this.mGenerate.println(lindent + lind1 + bindingObjVar + ".setSoapActionURI(mSoapActionURI);");
            }
            if (lrtype != null) {
                this.mConsole.println("Generate method call");
                if (!lrtype.equalsIgnoreCase("void")) {
                    this.mGenerate.println(lindent + lind1 + "lresult = t" + this.mPortName + "." + lName + lparmstr);
                } else {
                    this.mGenerate.println(lindent + lind1 + "t" + this.mPortName + "." + lName + lparmstr);
                }
                this.mGenerate.println(lindent + lind1 + "mSoapResponse = t" + this.mPortName + ".getSoapResponse();");
                if (llist.size() > 0) {
                    for (int lc = 0; lc < llist.size(); ++lc) {
                        this.mGenerate.println((String)llist.get(lc));
                    }
                }
            }
            this.mConsole.println("Handle return value.");
            this.mGenerate.println(lindent + "}");
            this.mGenerate.println(lindent + "catch (Exception e)");
            this.mGenerate.println(lindent + "{");
            this.mGenerate.println(lindent + "  mLastError = new String(\"Exception: \"+e);");
            this.mGenerate.println(lindent + "}");
            this.mGenerate.println();
            if (lRetType != null) {
                this.handleReturnType(lRetType, lpath);
            }
            this.mGenerate.println("  }");
            this.mGenerate.println();
            this.mGenerate.flush();
        }
        this.mConsole.println("Close Generator");
        this.closeGenerator();
        this.mConsole.println("generateJava Out - success");
        return true;
    }

    public String getLastError() {
        return this.mLastError;
    }

    private String getInitVal(String pType) {
        String initval = pType.equals("byte") || pType.equals("short") || pType.equals("int") || pType.equals("long") || pType.equals("float") || pType.equals("double") || pType.equals("char") ? "0" : (pType.equals("boolean") ? "false" : "null");
        return initval;
    }
}

