/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.axis2.wsdl.WSDL2Java;
import webcore.codegen;
import webcore.interfacereader;
import webcore.wsecurity;

class axisrunner {
    private String mDestFolder = null;
    private String mWSDL = null;
    private PrintStream mStream;
    private String mLastError = null;
    private String mPortName = null;

    public axisrunner(String pDestFolder, String pWSDL, String portName) {
        this.mDestFolder = pDestFolder;
        this.mWSDL = pWSDL;
        if (portName != null && portName.length() > 0) {
            this.mPortName = portName;
        }
        String lsep = System.getProperty("file.separator");
        String lfilename = this.mDestFolder + lsep + "axislog.txt";
        try {
            File lfile = new File(lfilename);
            if (lfile.exists()) {
                lfile.delete();
            }
            this.mStream = new PrintStream(new FileOutputStream(lfile));
        }
        catch (FileNotFoundException ex) {
            this.mLastError = "axisrunner exception in webcore: Could not create axislog.txt";
        }
    }

    public boolean processAxisErrors() {
        boolean lresult = true;
        this.mLastError = null;
        interfacereader lreader = new interfacereader();
        String lfilename = this.mDestFolder + System.getProperty("file.separator") + "axislog.txt";
        if (lreader.openSource(lfilename)) {
            this.mLastError = lreader.readLine();
            if (this.mLastError != null && this.mLastError.indexOf("webcore") != -1) {
                this.mLastError = null;
            } else {
                lresult = false;
            }
            lreader.closeSource();
        }
        return lresult;
    }

    public boolean callAxis(String pPackageName) {
        boolean lresult = true;
        pPackageName = pPackageName.replaceAll(" ", "_");
        String[] largs = this.mPortName != null ? new String[]{"-uri", this.mWSDL, "-s", "-d", "adb", "-o", this.mDestFolder, "-p", pPackageName, "-pn", this.mPortName} : new String[]{"-uri", this.mWSDL, "-s", "-d", "adb", "-o", this.mDestFolder, "-p", pPackageName};
        if (codegen.smThreadLogging) {
            codegen.mConsole.println("callAxis: start of function..");
        }
        PrintStream curStream = System.err;
        System.setErr(this.mStream);
        wsecurity wcm = new wsecurity();
        System.setSecurityManager(wcm);
        try {
            WSDL2Java.main((String[])largs);
        }
        catch (Exception e) {
            System.setErr(curStream);
            this.mStream.flush();
            this.mStream.close();
            System.setSecurityManager(null);
            lresult = this.processAxisErrors();
            if (this.mLastError == null) {
                Throwable t = e.getCause();
                if (t != null) {
                    this.mLastError = t.getMessage();
                }
                if (this.mLastError == null) {
                    this.mLastError = e.getMessage();
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            sb.append('\n');
            sb.append(this.mLastError);
            this.mLastError = sb.toString();
        }
        System.setErr(curStream);
        this.mStream.flush();
        this.mStream.close();
        System.setSecurityManager(null);
        if (codegen.smThreadLogging) {
            codegen.mConsole.println("callAxis: end of function..");
        }
        return lresult;
    }

    public String getLastError() {
        return this.mLastError;
    }
}

