/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import webcore.PortNode;
import webcore.ServiceNode;
import webcore.codegen;
import webcore.iConsole;

public class WSDLContentHandler
implements ContentHandler {
    private Locator locator;
    private final Map<String, String> namespaceMappings = new HashMap<String, String>();
    private final Map<String, String> portTypes = new HashMap<String, String>();
    private final ArrayList<ServiceNode> mServiceList = new ArrayList();
    private ServiceNode mServiceNode;
    private PortNode mPortNode;
    private boolean foundSoapBinding;
    private boolean inBinding;
    private String bindingName;
    private String portTypeName;
    private ArrayList<String> mPortBindings;
    private final ArrayList<String> mDocNames = new ArrayList();
    private final ArrayList<Integer> mDocTypes = new ArrayList();
    private final ArrayList<String> mDocDocs = new ArrayList();
    private boolean mInDocElement;
    private int mDocLevel;
    private String mServiceName;
    private String mOperationName;
    private final String SERVICE_KEY = "service";
    private final String PORT_KEY = "port";
    private final String NAME_KEY = "name";
    private final String TYPE_KEY = "type";
    private final String BINDING_KEY = "binding";
    private final String OPERATION_KEY = "operation";
    private final String SOAP_BINDING_KEY = "soap:binding";
    private final String DOCUMENTATION_KEY = "documentation";
    private final int DOC_LEVEL_SERVICE = 1;
    private final int DOC_LEVEL_OPERATION = 2;
    private final int DOC_LEVEL_PARAMS = 3;
    private final int DOC_LEVEL_RETURN = 4;
    private final iConsole mConsole = codegen.mConsole;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(uri, prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        for (String uri : this.namespaceMappings.keySet()) {
            String thisPrefix = this.namespaceMappings.get(uri);
            if (!prefix.equals(thisPrefix)) continue;
            this.namespaceMappings.remove(uri);
            break;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String operationName;
        this.mConsole.println("startElement : " + localName);
        if (localName.equals("service")) {
            this.mPortBindings = new ArrayList();
            this.mConsole.println("Found Service");
            String serviceName = atts.getValue("name");
            serviceName = this.formatName(serviceName);
            this.mConsole.println("Service name : " + serviceName);
            this.mServiceNode = new ServiceNode(serviceName);
            this.mServiceName = serviceName;
            this.mDocLevel = 1;
        }
        if (localName.equals("port")) {
            this.mConsole.println("Found Port");
            String portName = atts.getValue("name");
            String portBinding = atts.getValue("binding");
            portName = this.formatName(portName);
            portBinding = portBinding.substring(portBinding.indexOf(":") + 1, portBinding.length());
            portBinding = this.formatName(portBinding);
            this.mConsole.println("portBinding : " + portBinding + " this.bindingName : " + this.bindingName);
            if (portBinding.equals(this.bindingName)) {
                portName = portName + "," + portBinding;
                this.mConsole.println("Port details : " + portName);
                this.mServiceNode.addPort(new PortNode(portName));
            }
            this.mPortBindings.add(portBinding);
        }
        if (localName.equals("binding")) {
            this.mConsole.println("ns:" + namespaceURI + " ln:" + localName + " qn:" + qName);
            if (!this.foundSoapBinding && this.inBinding) {
                if (qName.equals("soap:binding")) {
                    this.mConsole.println("Found Soap Binding");
                    this.foundSoapBinding = true;
                    if (this.bindingName != null) {
                        this.bindingName = this.formatName(this.bindingName);
                    }
                    if (this.portTypeName != null) {
                        this.portTypeName = this.formatName(this.portTypeName);
                    }
                    this.mConsole.println("Binding details : " + this.bindingName + " - " + this.portTypeName);
                    this.portTypes.put(this.bindingName, this.portTypeName);
                }
            } else if (!this.foundSoapBinding) {
                this.mConsole.println("Found Binding");
                this.bindingName = atts.getValue("name");
                this.portTypeName = atts.getValue("type");
                if (this.bindingName != null) {
                    this.bindingName = this.formatName(this.bindingName);
                }
                if (this.portTypeName != null) {
                    this.portTypeName = this.formatName(this.portTypeName);
                }
                this.portTypes.put(this.bindingName, this.portTypeName);
                this.inBinding = true;
            }
        }
        if (localName.equals("documentation")) {
            this.mInDocElement = true;
        }
        if (localName.equals("operation") && (operationName = atts.getValue("name")) != null) {
            this.mOperationName = this.formatName(operationName);
            this.mDocLevel = 2;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("binding")) {
            this.inBinding = false;
        }
        if (localName.equals("service")) {
            this.mConsole.println("Service End");
            this.mConsole.println("Service Node Size: " + this.mServiceNode.getPorts().size());
            this.mServiceList.add(this.mServiceNode);
            this.mDocLevel = 0;
        }
        if (localName.equals("documentation")) {
            this.mInDocElement = false;
        }
        if (localName.equals("operation")) {
            this.mDocLevel = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mInDocElement) {
            String docs = new String(ch, start, length);
            switch (this.mDocLevel) {
                case 1: {
                    this.mDocNames.add(this.mServiceName);
                    this.mDocTypes.add(new Integer(1));
                    this.mDocDocs.add(docs);
                    break;
                }
                case 2: {
                    this.mDocNames.add(this.mOperationName);
                    this.mDocTypes.add(new Integer(2));
                    this.mDocDocs.add(docs);
                    break;
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public boolean parseWSDL(String xmlFilePath) {
        this.mConsole.println("parseWSDL In (" + xmlFilePath + ")");
        try {
            URL rurl;
            this.inBinding = false;
            this.foundSoapBinding = false;
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            String lhttpStr = xmlFilePath.substring(0, 4);
            boolean lhttp = lhttpStr.equalsIgnoreCase("http");
            if (!lhttp) {
                File localfile = new File(xmlFilePath);
                rurl = localfile.toURI().toURL();
            } else {
                rurl = new URL(xmlFilePath);
            }
            this.mConsole.println("Opening connection to " + xmlFilePath + "...");
            URLConnection urlConn = rurl.openConnection();
            InputStreamReader inStream = new InputStreamReader(urlConn.getInputStream());
            InputSource inputSource = new InputSource(inStream);
            reader.parse(inputSource);
        }
        catch (Exception e) {
            this.mConsole.println("Error: " + e);
            this.mConsole.println("parseWSDL Out");
            return false;
        }
        this.mConsole.println("parseWSDL Out Success");
        return true;
    }

    public ArrayList<ServiceNode> getServiceList() {
        return this.mServiceList;
    }

    public String getPortType(String pBinding) {
        return this.portTypes.get(pBinding);
    }

    private String formatName(String pName) {
        pName = pName.substring(pName.indexOf(":") + 1, pName.length());
        boolean capNext = false;
        if (pName.indexOf(".") > 0) {
            capNext = true;
        }
        String name = new String();
        for (int i = 0; i < pName.length(); ++i) {
            Character cChar = new Character(pName.charAt(i));
            String sChar = cChar.toString();
            if (sChar.equals(".")) {
                capNext = true;
                continue;
            }
            name = capNext ? name.concat(sChar.toUpperCase()) : name.concat(sChar);
            capNext = false;
        }
        this.mConsole.println("formatName: " + pName + " to " + name);
        return name;
    }

    public ArrayList<String> getPortBindings() {
        return this.mPortBindings;
    }

    public Object[] getDocumentation() {
        this.mConsole.println("In WSDLContentHandler getDocumentation()");
        Object[] documentation = new Object[3];
        this.mConsole.println("Name Docs: " + this.mDocNames.size());
        documentation[0] = this.mDocNames.toArray();
        this.mConsole.println("Type Docs: " + this.mDocTypes.size());
        documentation[1] = this.mDocTypes.toArray();
        this.mConsole.println("Docs Docs: " + this.mDocDocs.size());
        documentation[2] = this.mDocDocs.toArray();
        this.mConsole.println("Out WSDLContentHandler getDocumentation()");
        return documentation;
    }
}

