/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import webcore.NullConsole;
import webcore.codegen;
import webcore.iConsole;

public final class JarResources {
    public boolean debugOn = false;
    private final HashMap<String, Integer> htSizes = new HashMap();
    private final HashMap<String, byte[]> htJarContents = new HashMap();
    private final String jarFileName;
    private final iConsole mConsole;

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.mConsole = this.debugOn ? codegen.mConsole : new NullConsole();
        this.init();
    }

    public byte[] getResource(String name) {
        return this.htJarContents.get(name);
    }

    private void init() {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ze = e.nextElement();
                this.mConsole.println(this.dumpZipEntry(ze));
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
            fis = new FileInputStream(this.jarFileName);
            bis = new BufferedInputStream(fis);
            zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                int chunk;
                if (ze.isDirectory()) continue;
                this.mConsole.println("ze.getName()=" + ze.getName() + ",getSize()=" + ze.getSize());
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                this.mConsole.println(ze.getName() + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException e) {
            this.mConsole.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closeIStream(zis);
        this.closeIStream(bis);
        this.closeIStream(fis);
    }

    private void closeIStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuilder sb = new StringBuilder();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append(ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        args = new String[]{"C:\\builds\\$430-002\\java\\webservices\\oOmWSClientWsstws_STWS064.jar", "_1._0._0._127.stws064.wsstws_wsdl.wsstws_omtypeOmClient"};
        if (args.length != 2) {
            System.err.println("usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        iConsole lConsole = codegen.mConsole;
        JarResources jr = new JarResources(args[0]);
        byte[] buff = jr.getResource(args[1]);
        if (buff == null) {
            lConsole.println("Could not find " + args[1] + ".");
        } else {
            lConsole.println("Found " + args[1] + " (length=" + buff.length + ").");
        }
    }

    public String getJarPath() {
        return this.jarFileName;
    }
}

