/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import webcore.codegen;
import webcore.iConsole;

public class JarFileCreator {
    public static int BUFFER_SIZE = 10240;
    private final iConsole mConsole = codegen.mConsole;

    protected void createJarArchive(File archiveFile, String pArchiveFolder) {
        try {
            FileOutputStream stream = new FileOutputStream(archiveFile);
            JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
            File lDir = new File(pArchiveFolder);
            File[] files = lDir.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                if (!files[i].exists() || !files[i].isDirectory()) continue;
                String path = files[i].getName() + "/";
                this.addFiles(stream, out, files[i].toString(), path);
            }
            out.close();
            stream.close();
            this.mConsole.println("Adding completed OK");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mConsole.println("Error: " + ex.getMessage());
        }
    }

    private void addFiles(FileOutputStream stream, JarOutputStream out, String pArchiveFolder, String pPath) throws Exception {
        File[] tobeJared = null;
        File lsrc = new File(pArchiveFolder);
        if (!lsrc.exists()) {
            throw new Exception("Unable to find Folder " + pArchiveFolder);
        }
        tobeJared = lsrc.listFiles();
        byte[] buffer = new byte[BUFFER_SIZE];
        for (File lFile : tobeJared) {
            int nRead;
            if (lFile == null || !lFile.exists()) continue;
            this.mConsole.println("Adding " + lFile.getName());
            if (lFile.isDirectory()) {
                String path = pPath + lFile.getName() + "/";
                this.addFiles(stream, out, lFile.getPath(), path);
                continue;
            }
            String entryName = pPath + lFile.getName();
            JarEntry jarAdd = new JarEntry(entryName);
            jarAdd.setTime(lFile.lastModified());
            out.putNextEntry(jarAdd);
            FileInputStream in = new FileInputStream(lFile);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
        }
    }
}

