/*
 * Decompiled with CFR 0.152.
 */
package webcore;

import java.io.File;
import java.io.FileInputStream;
import webcore.MultiClassLoader;

public class FileClassLoader
extends MultiClassLoader {
    private final String filePrefix;

    public FileClassLoader(String filePrefix, ClassLoader pParent) {
        super(pParent);
        this.filePrefix = filePrefix != null && !filePrefix.endsWith(File.separator) && !filePrefix.endsWith("/") ? filePrefix + File.separator : filePrefix;
    }

    @Override
    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        if (this.sourceMonitorOn) {
            FileClassLoader.print(">> from file: " + className);
        }
        String fileName = this.filePrefix + className;
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            byte[] result = new byte[inStream.available()];
            inStream.read(result);
            inStream.close();
            return result;
        }
        catch (Exception e) {
            FileClassLoader.print("### File '" + fileName + "' not found.");
            return null;
        }
    }
}

